# UCI config guide for logmngr

A sample uci config would be

## syslog-ng backend

```
config globals
    option enable '1'
    
config filter 'f1'
    option name 'fl1'
    option facility_level '4'
    
config filter 'f2'
    option name 'fl2'
    option severity_level '3'
    option severity_compare '0'
    option severity_action '0'

config action 'a1'
    option name 'ac1'
    option filter 'fl1 fl2'

config log_file 'lf1'
    option enable '1'
    option action 'ac1'
    option file '/var/log/messages'
    
config log_remote 'lr1'
    option enable '1'
    option action 'ac1'
    option log_ip '1.1.8.1'
    option port '514'
    option proto 'tls'
    option cert  '/var/certs/cert_file.pem'
    option peer_verify '1'

config log_rotate 'lrot1'
    option enable '1'
    option file_name '/var/log/messages'
    option file_count '4'
    option max_file_size '4096'
    option duration '1440'
    option retention '10080'
    option compression 'xz'
```

## Fluent-bit backend

- Fluent-bit has support for source and template sections. These can be added and then referred to in the action section.
- Other things remain the same as syslog-ng backend.

```
config globals 'globals'
	option enable '1'

config source 'default_source'
	option name 'default_source'
	option system_messages '1'
	option kernel_messages '1'

config template 'default_template'
	option name 'default_template'
	option expression '{time} {hostname} {ident}: {message}'

config action 'default_action'
	option name 'default_action'
	list source 'default_source'
	option template 'default_template'

config log_file 'lf1'
	option enable '1'
	option action 'default_action'
	option file '/var/log/messages'

config log_remote 'lr1'
	option enable '0'
	option action 'default_action'
	option port '514'
```

## Notes
- The filter and action section have a name associated with them.
- The filter section is referred to by the option name in the config action section.
- The config action section is referred to be the option name in the config
  log_file and config log_remote section.
- There is a one to one mapping of sections and options to the data model.
- Compile time flag CONFIG_LOGMNGR_MIGRATE_OLD_UCI can be used to control whether or not to add source and template sections in the UCI (if they are not present after defaultreset/upgrade).

