## Syslog datamodel to UCI mapping

The current proposal is to support fluent-bit and syslog-ng as the backend for logmngr. This document proposes datamodel to UCI mapping for each.\

## Implementation proposal for logmngr

The logmngr should have a uci mapping to data model and then we should have library scripts for converting this to /etc/syslog-ng.conf in case of backend being syslog-ng and /etc/fluent-bit/fluent-bit.conf in case of backend being fluent-bit, respectively.

## Datamodel to UCI mapping

The data model to uci config with logmngr is proposed as follows,
```
Device.Syslog.
Enable                  |    logmngr.globals.enable
Status                  |    read logmngr.globals.enable

Device.Syslog.Filter.{i}.
Alias                   |    standard bbfdm implementation
FacilityLevel           |    logmngr.filter.facility_level
SeverityCompare         |    logmngr.filter.severity_compare
SeverityCompareAction   |    logmngr.filter.severity_action
PatternMatch            |    logmngr.filter.pattern_match

Device.Syslog.Source.{i}.
Alias                   |    standard bbfdm implementation
SystemMessages          |    logmngr.source.system_messages
KernelMessages          |    logmngr.source.kernel_messages

Device.Syslog.Template.{i}.
Alias                   |    standard bbfdm implementation
Expression              |    logmngr.template.expression

Device.Syslog.Action.{i}.
Alias                   |    standard bbfdm implementation
FilterRef               |    logmngr.action.filter
note: each action section will be assigned a name which will be referenced by its child log_file and log_remote section by the option action

Device.Syslog.Action.{i}.LogFile.
Enable                  |    logmngr.log_file.enable
VendorLogFileRef        |    extract log file name from the object referenced
FilePath                |    logmngr.log_file.file
note: in the uci section logmngr.log_file, option action will refer to the config action section by its name.

Device.Syslog.Action.{i}.LogRemote.
Enable                  |    logmngr.log_remote.enable
Address                 |    logmngr.log_remote.log_ip
Protocol                |    logmngr.log_remote.proto
Port                    |    logmngr.log_remote.log_port
Certificate             |    logmngr.log_remote.certificate
PeerVerify              |    logmngr.log_remote.peer_verify
note: in the uci section logmngr.log_remote, option action will refer to the config action section by its name.

Device.DeviceInfo.LogRotate.{i}.
Alias                   |    standard bbfdm implementation
Enable                  |    logmngr.log_rotate.enable
Name                    |    logmngr.log_rotate.file_name
NumberOfFiles           |    logmngr.log_rotate.file_count
MaxFileSize             |    logmngr.log_rotate.max_file_size
RollOver                |    logmngr.log_rotate.duration
Retention               |    logmngr.log_rotate.retention
Compression             |    logmngr.log_rotate.compression
LogFileNumberOfEntries  |    standard bbfdm implementation

Device.DeviceInfo.LogRotate.{i}.LogFile.{i}.
Alias                   |    standard bbfdm implementation
Name                    |    read actual name from rotated files
Size                    |    read actual name from rotated files
LastChange              |    read actual from rotated file
```

- Source is currently only functional for fluent-bit backend, for syslog-ng it is hard-coded to /dev/log and configuring this object with syslog-ng backend will have no effect.
