#include <stddef.h>

#include "common.h"

#define ARRAY_SIZE(x) (sizeof(x) / sizeof(x[0]))

char *FacilityLevel[] = {"Kern", "User", "Mail", "Daemon", "Auth", "Syslog", "LPR", "News", "UUCP", "Cron", "AuthPriv", "FTP", "NTP", "Audit", "Console", "Cron2", "Local0", "Local1", "Local2", "Local3", "Local4", "Local5", "Local6", "Local7", "All", NULL};
char *Severity[] = {"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Info", "Debug", "All", "None", NULL};
char *SeverityCompare[] = {"Equal", "EqualOrHigher", NULL};
char *SeverityCompareAction[] = {"Log", "Block", "Stop", NULL};
char *Protocol[] = {"TCP", "UDP", "TLS", NULL};
char *Compression[] = {"None", "GZIP", "XZ", NULL};
char *vendor_log_dir[] = {"/var/log", "/log", NULL};

/* this has to be done here, if the scope changes, then array will decay to pointer type and sizeof will throw error */
int FacilityMax = ARRAY_SIZE(FacilityLevel);
int SeverityMax = ARRAY_SIZE(Severity);
int CompareMax = ARRAY_SIZE(SeverityCompare);
int ActionMax = ARRAY_SIZE(SeverityCompareAction);
