#!/bin/bash

# This script parses the Doxygen-styled comments in 'wifiops.h' to
# extract WiFi Radio and Interface APIs and tabulate in markdown format.

if [ "$#" -ne 1 ]; then
    echo "Usage: $0 wifiops.h > README-APIs.md"
    exit 1
fi

input_file="$1"

awk '
BEGIN {
	func_signature = ""
	func_desc = ""
	params = ""
}

/^\s*\*\s*@struct wifi_radio_ops/ {
	print "## Wi-Fi Radio Operations"
	print "| Function Signature | Description | Parameters |"
	print "|--------------------|-------------|------------|"
	next
}

/^\s*\*\s*@struct wifi_iface_ops/ {
	print "## Wi-Fi Interface Operations"
	print "| Function Signature | Description | Parameters |"
	print "|--------------------|-------------|------------|"
	next
}

/^\s*\*\s*<b>/ {
	# Reset variables for a new function block
	func_signature = ""
	func_desc = ""
	params = ""

	# Extract function signature
	gsub(/\\n|<b>|<\/b>|[/.]/, "", $0)
	func_signature = substr($0, index($0, "*") + 2)
	next
}

/^\s*\*\s*@brief/ {
	# Extract description
	func_desc = substr($0, index($0, "@brief") + 6)
	next
}

/^\s*\*\s*@param/ {
	# Extract parameters
	param_dir = ($3 ~ /out/) ? "[out]" : "[in]"
	param_name = $4
	param_desc = substr($0, index($0, $5))
	params = params "**" param_dir " " param_name "**: " param_desc "<br> "
	next
}

/^\s*\*\s*$/ {
	# When hitting an empty line, output the collected function details
	if (func_signature && func_desc) {
		gsub(/<br> $/, "", params)
		print "| " func_signature " | " func_desc " | " params " |"
	}
	# Clear variables to prepare for the next function block
	func_signature = ""
	func_desc = ""
	params = ""
	next
}' "$input_file"
