/* SPDX-License-Identifier: LGPL-2.1-only */
/*
 * drivers.h - WiFi backends header file
 *
 * Copyright (C) 2019-2024 Iopsys Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 */
#ifndef LIBWIFI_DRIVERS_H
#define LIBWIFI_DRIVERS_H

#include <easy/easy.h>
#include "wifi.h"

#ifdef WIFI_BROADCOM
#ifdef CONFIG_BCM963138
extern const struct wifi_driver bcm_driver;
#else
extern const struct wifi_driver brcm_driver;
#endif
#endif

#ifdef WIFI_MEDIATEK
#ifdef CONFIG_MTK
extern const struct wifi_driver mtk_driver;
extern const struct wifi_driver mtk_mld_driver;
#else
extern const struct wifi_driver mt_driver;
#endif
#endif

#ifdef WIFI_QUALCOMM
extern const struct wifi_driver qca_driver;
#endif

#ifdef WIFI_INTEL
extern const struct wifi_driver intel_driver;
#endif

#ifdef WIFI_TEST
extern const struct wifi_driver test_driver;
#endif

extern const struct wifi_driver default_wifi_driver;

#endif /* LIBWIFI_DRIVERS_H */
