
## Overview

libwifi provides two distinct libraries -

* libwifiutils.so
* libwifi-7.so


`libwifiutils.so` provides Wi-Fi utility functions and common definitions,
which are not dependent on any Wi-Fi hardware or driver.
Since the library is not agnostic to Wi-Fi implementation, it can be used in
any platform, even the ones having no Wi-Fi.

`libwifi-7.so` provides Wi-Fi HAL (Hardware Abstraction Layer) APIs for different
Wi-Fi chipsets and drivers. Depending on the built-time config options that
identify a Wi-Fi hardware and/or driver architecture, appropriate Wi-Fi modules
are built into the library.


## Architecture

![libwifi module layers](docs/img/libwifi-layer-arch.png "libwifi module layer diagram")



## Supported Wi-Fi hardware

The **modules** directory contains sub-directories, each containing HAL APIs'
implementation for a specific Wi-Fi hardware and/or driver.

See 'Directory organization' section for the list of supported Wi-Fi modules.

## API list

````json
	"libwifi_get_apis",
	"wifi_driver_info",

	"wifi_radio_list",
	"wifi_radio_is_multiband",
	"wifi_radio_info",
	"wifi_radio_info_band",
	"wifi_get_supp_band",
	"wifi_get_oper_band",
	"wifi_radio_get_ifstatus",
	"wifi_radio_get_band_ifstatus",
	"wifi_radio_get_caps",
	"wifi_radio_get_band_caps",
	"wifi_get_supp_stds",
	"wifi_get_band_supp_stds",
	"wifi_get_oper_stds",
	"wifi_band_get_oper_stds",
	"wifi_get_country",
	"wifi_get_countrylist",
	"wifi_get_channel",
	"wifi_get_band_channel",
	"wifi_set_channel",  /* deprecated */
	"wifi_get_supp_channels",
	"wifi_get_band_supp_channels",
	"wifi_get_oper_channels",
	"wifi_get_supp_opclass",
	"wifi_get_band_supp_opclass",
	"wifi_get_curr_opclass",
	"wifi_get_band_curr_opclass",
	"wifi_get_bandwidth",
	"wifi_get_supp_bandwidths",
	"wifi_get_band_supp_bandwidths",
	"wifi_get_maxrate",
	"wifi_get_band_maxrate",
	"wifi_get_basic_rates",
	"wifi_get_oper_rates",
	"wifi_get_supp_rates",
	"wifi_radio_get_stats",
	"wifi_radio_get_band_stats",
	"wifi_scan",
	"wifi_scan_ex",
	"wifi_scan_band_ex",
	"wifi_get_scan_results",
	"wifi_get_band_scan_results",
	"wifi_get_bss_scan_result",
	"wifi_get_noise",
	"wifi_acs",
	"wifi_radio_get_param",
	"wifi_radio_set_param",
	"wifi_radio_get_hwaddr",
	"wifi_add_iface",
	"wifi_del_iface",
	"wifi_list_iface",
	"wifi_channels_info",
	"wifi_band_channels_info",
	"wifi_start_cac",
	"wifi_stop_cac",
	"wifi_get_opclass_preferences",
	"wifi_get_band_opclass_preferences",
	"wifi_simulate_radar",

	"wifi_start_wps",
	"wifi_stop_wps",
	"wifi_get_wps_status",
	"wifi_get_wps_pin",
	"wifi_set_wps_pin",
	"wifi_get_wps_device_info",
	"wifi_get_caps",
	"wifi_get_mode",
	"wifi_get_security",
	"wifi_interface_get_channel",
	"wifi_add_vendor_ie",
	"wifi_del_vendor_ie",
	"wifi_get_vendor_ies",
	"wifi_get_param",
	"wifi_set_param",
	"wifi_vendor_cmd",
	"wifi_subscribe_frame",
	"wifi_unsubscribe_frame",
	"wifi_send_action_frame",
	"wifi_dpp_listen",
	"wifi_dpp_stop_listen",
	"wifi_set_4addr",
	"wifi_get_4addr",
	"wifi_get_4addr_parent",
	"wifi_set_vlan",
	"wifi_link_measure",
	"wifi_get_mlo_links",
	"wifi_get_ctrl_interface",
	"wifi_get_ctrl_interface_band",

	"wifi_ap_info",
	"wifi_ap_info_band",
	"wifi_get_bssid",
	"wifi_get_ssid",
	"wifi_ap_get_stats",
	"wifi_get_beacon_ies",
	"wifi_get_beacon_ies_band",
	"wifi_get_assoclist",
	"wifi_get_assoclist_band",
	"wifi_get_sta_info",
	"wifi_get_sta_info_band",
	"wifi_get_sta_stats",
	"wifi_disconnect_sta",
	"wifi_restrict_sta",
	"wifi_block_sta",
	"wifi_get_blocked_stas",
	"wifi_monitor_sta",
	"wifi_get_monitor_sta",
	"wifi_get_monitor_stas",
	"wifi_probe_sta",
	"wifi_add_neighbor",
	"wifi_del_neighbor",
	"wifi_get_neighbor_list",
	"wifi_req_beacon_report",
	"wifi_get_beacon_report",
	"wifi_req_bss_transition",
	"wifi_req_btm",
	"wifi_get_11rkeys",
	"wifi_set_11rkeys",
	"wifi_chan_switch",
	"wifi_mbo_disallow_assoc",
	"wifi_ap_set_state",
	"wifi_ap_set_qos_map",
	"wifi_ap_send_qos_map_conf",
	"wifi_get_mlsta_info",

	"wifi_sta_info",
	"wifi_mlsta_interface_info",
	"wifi_sta_get_stats",
	"wifi_sta_get_ap_info",
	"wifi_sta_disconnect_ap",
	"wifi_sta_get_stats_ex",

	"wifi_register_event",
	"wifi_recv_event",
	"libwifi_get_version",
````

## Directory organization

* wifiutils.h - library header file for libwifiutils.so.
* wifi.h - library header file for libwifi-7.so.
* wifiops.h - defines wifi\_radio and wifi_\interface operations.
* wifidefs.h - header file defining Wi-Fi structs.
* wifiops.c - libwifi APIs implementation file.

* modules - directory containing module implementations for different Wi-Fi chipsets and drivers.
* modules/default/* - has "default" wifi\_driver implemenatation, which is based on nl80211, hostapd\_cli and wpa\_supplicant\_cli.
* modules/nl80211/* - contains implemenatation for wifi\_driver suppoorting NL80211\_CMD interfaces.
* modules/hostapd-cli/* - contains the APIs' implemenatation that use the hostapd's ctrl-interface.
* modules/wpa\_supplicant-cli/* - has API implemenatations that use the wpa\_supplicant's ctrl-interface.
* modules/broadcom/* - contains wifi\_driver implemenatation for Broadcom Wi-Fi chipsets.
* modules/qualcomm/* - contains wifi\_driver implemenatation for Qualcomm Wi-Fi chipsets.
* modules/mediatek/* - contains wifi\_driver implemenatation for Mediatek Wi-Fi chipsets.
* modules/intel/* - contains wifi\_driver implemenatation for Intel/Maxlinear Wi-Fi chipsets.
* modules/wext/* - contains wifi\_driver implemenatation supporting Wireless Extension (WE). Now deprecated. DO NOT USE.
* modules/test/* - contains wifi\_driver for unit-testing purpose.



## Build instructions

* To build and install only libwifiutils.so -

````bash
$ make
$ [sudo] make install
````

* To build libwifi-7.so for CFG80211 or MAC80211 based Wi-Fi drivers -

````bash
$ CFLAGS="-DHAS_WIFI=1" make
$ [sudo] CFLAGS="-DHAS_WIFI=1" make install
````

* To build libwifi-7.so for unit-testing -

````bash
$ WIFI_TYPE=TEST CFLAGS="-DHAS_WIFI=1" make
$ [sudo] WIFI_TYPE=TEST CFLAGS="-DHAS_WIFI=1" make install
````

* To clean the library, simply run -

````bash
$ make clean
````

## Dependencies

The build and runtime dependencies are -

* libeasy (https://dev.iopsys.eu/hal/libeasy.git)
* libnl-3 (https://github.com/thom311/libnl.git)
* libnl-genl-3 (https://github.com/thom311/libnl.git)
* libnl-route-3 (https://github.com/thom311/libnl.git)

Additionally, based on the specific Wi-Fi module type, extra dependencies may be needed.

## Versioning

The library `libwifiutils.so` is not versioned.

The library `libwifi-7.so` is versioned in semantic notation.
The version string "libwifi\_version" is defined in 'wifi.h'.

The file 'VERSION.txt' holds the library's major number, which must be incremented
for every non-backward compatible change introduced in the library.

The library soname is `"libwifi-7.so.$(maj)"`, where $(maj) is the major
number from VERSION.txt.

## Tests


## Debugging

