// SPDX-License-Identifier: LGPL-2.1-only
/*
 * wext.h - WE related apis to be used _only_ internally by this lib
 *
 * Copyright (C) 2018-2024 Iopsys Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 */
#ifndef WEXT_H
#define WEXT_H

#include <stdint.h>
#include <linux/types.h>

#ifdef __cplusplus
extern "C" {
#endif

struct scan_param;

#if __GNUC__ >= 4
# define LIBWIFI_INTERNAL	__attribute__((visibility("hidden")))
#else
# define LIBWIFI_INTERNAL
#endif

LIBWIFI_INTERNAL int wext_scan(const char *ifname, struct scan_param *p);
LIBWIFI_INTERNAL int wext_get_scan_results(const char *ifname,
					struct wifi_bss **bsss, int *num);
LIBWIFI_INTERNAL int wext_get_ssid(const char *ifname, char *ssid);
LIBWIFI_INTERNAL int wext_get_bssid(const char *ifname, char *bssid);
LIBWIFI_INTERNAL int wext_get_channel_list(const char *ifname, uint32_t *chlist,
				int *num, const char *cc, enum wifi_band band,
				enum wifi_bw bw);
LIBWIFI_INTERNAL int wext_get_channel(const char *ifname, uint32_t *channel,
							enum wifi_bw *bw);

LIBWIFI_INTERNAL int wext_get_security(const char *ifname, uint32_t *auth,
					uint32_t *enc);

#ifdef __cplusplus
}
#endif
#endif /* WEXT_H */
