// SPDX-License-Identifier: LGPL-2.1-only
/**
 * wifi.h - libwifi-*.so library header file.
 *
 * Copyright (C) 2020-2024 iopsys Software Solutions AB. All rights reserved.
 *
 * @author anjan.chanda@iopsys.eu
 */
#ifndef WIFI_H
#define WIFI_H

#include <stdint.h>
#include <stdbool.h>
#include <linux/types.h>

#include <wifiutils.h>
#include "wifiops.h"

#ifdef __cplusplus
extern "C" {
#endif

/** API versioning stuff */
#define str(s)	_str(s)
#define _str(s)	#s
#define libwifi_version		\
	str(LIBWIFI_MAJOR)"."str(LIBWIFI_MINOR)"-"str(LIBWIFI_REV)


#ifdef __cplusplus
}
#endif

#endif /* WIFI_H */
