// SPDX-License-Identifier: LGPL-2.1-only
#ifndef SUPPLICANT_CTRL_H
#define SUPPLICANT_CTRL_H

#define KEY_MGMT_WPA            0x00000001
#define KEY_MGMT_WPA2           0x00000002
#define KEY_MGMT_WPA_PSK        0x00000004
#define KEY_MGMT_WPA2_PSK       0x00000008
#define KEY_MGMT_WPA_NONE       0x00000010
#define KEY_MGMT_FT             0x00000020
#define KEY_MGMT_FT_PSK         0x00000040
#define KEY_MGMT_WAPI_PSK       0x00000080
#define KEY_MGMT_SUITE_B        0x00000100
#define KEY_MGMT_SUITE_B_192    0x00000200
#define KEY_MGMT_OWE            0x00000400
#define KEY_MGMT_DPP            0x00000800
#define KEY_MGMT_FILS_SHA256    0x00001000
#define KEY_MGMT_FILS_SHA384    0x00002000
#define KEY_MGMT_FT_FILS_SHA256 0x00004000
#define KEY_MGMT_FT_FILS_SHA384 0x00008000
#define KEY_MGMT_SAE            0x00010000
#define KEY_MGMT_802_1X_SHA256  0x00020000
#define KEY_MGMT_PSK_SHA256     0x00040000
#define KEY_MGMT_TPK_HANDSHAKE  0x00080000
#define KEY_MGMT_FT_SAE         0x00100000
#define KEY_MGMT_FT_802_1X_SHA384       0x00200000
#define KEY_MGMT_CCKM           0x00400000
#define KEY_MGMT_OSEN           0x00800000

#define ENC_WEP40       0x00000001
#define ENC_WEP104      0x00000002
#define ENC_TKIP        0x00000004
#define ENC_CCMP        0x00000008
#define ENC_WEP128      0x00000010
#define ENC_GCMP        0x00000020
#define ENC_GCMP_256    0x00000040
#define ENC_CCMP_256    0x00000080
#define ENC_BIP         0x00000100
#define ENC_BIP_GMAC_128        0x00000200
#define ENC_BIP_GMAC_256        0x00000400
#define ENC_BIP_CMAC_256        0x00000800
#define ENC_GTK_NOT_USED        0x00001000

int supplicant_sta_info(const char *ifname, struct wifi_sta *info);
int supplicant_cli_get_oper_std(const char *ifname, uint8_t *std);
int supplicant_cli_get_sta_supported_security(const char *ifname, uint32_t *sec);
int supplicant_cli_get_sta_security(const char *ifname, struct wifi_sta_security *sec);
int supplicant_cli_get_ssid(const char *ifname, char *ssid, size_t ssid_size);

#endif /* SUPPLICANT_CTRL_H */
