/* SPDX-License-Identifier: LGPL-2.1-only */
/*
 * drivers.c - list of wifi backends
 *
 * Copyright (C) 2019-2024 Iopsys Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 */
#include <stdio.h>
#include "drivers.h"

const struct wifi_driver *wifi_drivers[] = {
#ifdef WIFI_BROADCOM
#ifdef CONFIG_BCM963138
	&bcm_driver,
#else
	&brcm_driver,
#endif
#endif /* WIFI_BROADCOM */

#ifdef WIFI_MEDIATEK
#ifdef CONFIG_MTK
	&mtk_driver,
	&mtk_mld_driver,
#else
	&mt_driver,
#endif
#endif

#ifdef WIFI_QUALCOMM
	&qca_driver,
#endif

#ifdef WIFI_INTEL
	&intel_driver,
#endif

#ifdef WIFI_TEST
	&test_driver,
#endif

	&default_wifi_driver,
};

uint32_t num_wifi_drivers = sizeof(wifi_drivers)/sizeof(wifi_drivers[0]);
