/* SPDX-License-Identifier: LGPL-2.1-only */
/*
 * debug.c - for debug prints to stderr.
 *
 * Copyright (C) 2020-2024 Iopsys Software Solutions AB. All rights reserved.
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <easy/easy.h>

void LIBEASY_API log_stderr(int level, const char *fmt, ...)
{
	va_list args;
	int iop_debug;
	char *e = getenv("LIBWIFI_DEBUG_LEVEL");

	iop_debug = e ? atoi(e) : -1;
	if (iop_debug < level)
		return;

	va_start(args, fmt);
	vfprintf(stderr, fmt, args);	/* Flawfinder: ignore */
	va_end(args);
}
