## Wi-Fi Radio Operations
| Function Signature | Description | Parameters |
|--------------------|-------------|------------|
| int (*list)(struct radio_entry *radio, int *num) |             Get list of preset radios | **[in] radio**: array<br> **[in] number**: of entries in radio array |
| int (*is_multiband)(const char *name, bool *res) |             Check if multiband radio. | **[in] radio**: interface name<br> **[in] result**:  *	@param[out] res   result |
| int (*info)(const char *name, struct wifi_radio *radio) |             Get information about the radio interface. | **[in] radio**: interface name<br> **[in] struct**: wifi_radio |
| int (*info_band)(const char *name, enum wifi_band band, struct wifi_radio *radio) |             Get information about the radio interface. | **[in] radio**: interface name<br> **[in] radio**: band   radio band - multiband case<br> **[in] struct**: wifi_radio |
| int (*get_supp_band)(const char *name, uint32_t *bands) |             Get supported WiFi bands in bands param. | **[in] radio**: interface name<br> **[in] bitmap**: of bands from struct wifi_band |
| int (*get_oper_band)(const char *name, enum wifi_band *band) |             Get current operating WiFi band. | **[in] radio**: interface name<br> **[in] band**: struct wifi_band type |
| int (*get_ifstatus)(const char *name, ifstatus_t *f) |             Get WiFi radio device flags | **[in] radio**: interface name<br> **[in] IFF_***: device flags |
| int (*get_band_ifstatus)(const char *name, enum wifi_band band, ifstatus_t *f) |             Get WiFi radio device flags | **[in] radio**: interface name<br> **[in] radio**: band   radio band - multiband case<br> **[in] IFF_***: device flags |
| int (*get_caps)(const char *name, struct wifi_caps *caps) |             Get WiFi radio capabilities. | **[in] radio**: interface name<br> **[in] capabilities**: struct wifi_caps |
| int (*get_band_caps)(const char *name, enum wifi_band band, struct wifi_caps *caps) |             Get WiFi radio capabilities. | **[in] radio**: interface name<br> **[in] radio**: band   radio band<br> **[in] capabilities**: struct wifi_caps |
| int (*get_supp_stds)(const char *name, uint8_t *std) |             Get WiFi supported standards. | **[in] radio**: interface name<br> **[in] bitmap**: of #enum wifi_std |
| int (*get_band_supp_stds)(const char *name, enum wifi_band band, uint8_t *std) |             Get WiFi supported standards. | **[in] radio**: interface name<br> **[in] radio**: band   radio band<br> **[in] bitmap**: of #enum wifi_std |
| int (*get_oper_stds)(const char *name, uint8_t *std) |             Get WiFi operational standards. | **[in] radio**: interface name<br> **[in] bitmap**: of enum wifi_std |
| int (*get_band_oper_stds)(const char *name, enum wifi_band band, uint8_t *std) |             Get WiFi operational standards. | **[in] radio**: interface name<br> **[in] radio**: band   radio band<br> **[in] bitmap**: of enum wifi_std |
| int (*get_country)(const char *name, char *alpha2) |              Get operating country information. | **[in] radio**: interface name<br> **[in] country**: code |
| int (*get_countrylist)(const char *name, char **c, int *num) |              Get supporting country list information. | **[in] radio**: interface name<br> **[in] country**: code of all supporting countries<br> **[in] count**: of countries in cc list |
| int (*get_channel)(const char *ifname, uint32_t *channel, enum wifi_bw *bw) |               Get operating channel information. | **[in] radio**: interface name<br> **[in] primary**: control channel<br> **[in] channel**: bandwidth |
| int (*get_band_channel)(const char *ifname, enum wifi_band band, uint32_t *channel, enum wifi_bw *bw) |               Get operating channel information. | **[in] radio**: interface name<br> **[in] radio**: band     radio band<br> **[in] primary**: control channel<br> **[in] channel**: bandwidth |
| int (*set_channel)(const char *ifname, uint32_t channel, enum wifi_bw bw) |               Set operating channel with bandwidth. | **[in] radio**: interface name<br> **[in] primary**: control channel<br> **[in] channel**: bandwidth |
| int (*get_supp_channels)(const char *name, uint32_t *chlist, int *num, |               Get supported channels. | **[in] radio**: interface name<br> **[in] array**: of channels<br> **[in] number**: of channels in chlist array<br> **[in] country**: code<br> **[in] frequency**: band #enum wifi_band<br> **[in] channel**: bandwidth enum wifi_bw |
| int (*get_oper_channels)(const char *name, uint32_t *chlist, int *num, |               Get operating channels. | **[in] radio**: interface name<br> **[in] array**: of channels<br> **[in] number**: of channels in chlist array<br> **[in] country**: code<br> **[in] frequency**: band #enum wifi_band<br> **[in] channel**: bandwidth enum wifi_bw |
| int (*get_supp_opclass)(const char *name, int *num, |               Get supported operating classes. | **[in] radio**: interface name<br> **[in] number**: of operating classes supported<br> **[in] array**: of struct wifi_opclass elements |
| int (*get_band_supp_opclass)(const char *name, enum wifi_band band, |               Get supported operating classes. | **[in] radio**: interface name<br> **[in] radio**: band     radio band<br> **[in] number**: of operating classes supported<br> **[in] array**: of struct wifi_opclass elements |
| int (*get_curr_opclass)(const char *name, int *num, |               Get current operating class(es). | **[in] radio**: interface name<br> **[in] number**: of current operating classes<br> **[in] array**: of struct wifi_opclass elements |
| int (*get_band_curr_opclass)(const char *name, enum wifi_band band, |               Get current operating class(es). | **[in] radio**: interface name<br> **[in] radio**: band     radio band<br> **[in] number**: of current operating classes<br> **[in] array**: of struct wifi_opclass elements |
| int (*get_bandwidth)(const char *name, enum wifi_bw *bw) |              Get operating channel bandwidth. | **[in] radio**: interface name<br> **[in] bandwidth**: #enum wifi_bw |
| int (*get_supp_bandwidths)(const char *name, uint32_t *bws) |              Get supported bandwidths | **[in] radio**: interface name<br> **[in] bitmask**: of supported BWs |
| int (*get_band_supp_bandwidths)(const char *name, enum wifi_band band, uint32_t *bws) |              Get supported bandwidths | **[in] radio**: interface name<br> **[in] radio**: band     radio band<br> **[in] bitmask**: of supported BWs |
| int (*get_maxrate)(const char *name, unsigned long *rate) |              Get maximum supported phy rate. | **[in] radio**: interface name<br> **[in] rate**: in Mbps |
| int (*get_band_maxrate)(const char *name, enum wifi_band band, unsigned long *rate) |              Get maximum supported phy rate. | **[in] radio**: interface name<br> **[in] radio**: band    radio band<br> **[in] rate**: in Mbps |
| int (*get_basic_rates)(const char *name, int *num, uint32_t *rates) |              Get basic phy rates. | **[in] radio**: interface name<br> **[in] number**: of elements in rates array<br> **[in] array**: of rates in Mbps |
| int (*get_oper_rates)(const char *name, int *num, uint32_t *rates) |              Get operational phy rates. | **[in] radio**: interface name<br> **[in] number**: of elements in rates array<br> **[in] array**: of rates in Mbps |
| int (*get_supp_rates)(const char *name, int *num, uint32_t *rates) |              Get supported phy rates. | **[in] radio**: interface name<br> **[in] number**: of elements in rates array<br> **[in] array**: of rates in Mbps |
| int (*get_stats)(const char *ifname, struct wifi_radio_stats *s) |              Get radio statistics. | **[in] radio**: interface name<br> **[in] radio**: stats and counters |
| int (*get_band_stats)(const char *ifname, enum wifi_band band, struct wifi_radio_stats *s) |              Get radio statistics. | **[in] radio**: interface name<br> **[in] radio**: band    radio band<br> **[in] radio**: stats and counters |
| int (*scan)(const char *name, struct scan_param *p) |              Trigger scanning. | **[in] radio**: interface name<br> **[in] scan**: request parameters |
| int (*scan_ex)(const char *ifname, struct scan_param_ex *sp) |              Trigger scanning. | **[in] radio**: interface name<br> **[in] scan**: request parameters |
| int (*scan_band_ex)(const char *ifname, enum wifi_band band, struct scan_param_ex *sp) |              Trigger scanning. | **[in] radio**: interface name<br> **[in] radio**: band    radio band<br> **[in] scan**: request parameters |
| int (*get_scan_results)(const char *name, struct wifi_bss *bsss, int *num) |              Get scan results. | **[in] radio**: interface name<br> **[in] array**: of scanned APs<br> **[in] number**: of scanned APs |
| int (*get_band_scan_results)(const char *name, enum wifi_band band, struct wifi_bss *bsss, int *num) |              Get scan results. | **[in] radio**: interface name<br> **[in] radio**: band    radio band<br> **[in] array**: of scanned APs<br> **[in] number**: of scanned APs |
| int (*get_bss_scan_result)(const char *name, uint8_t *bssid, |              Get scan result details of a specific AP. | **[in] radio**: interface name<br> **[in] bssid**: of a scanned AP<br> **[in] scan**: result including IE details |
| int (*get_noise)(const char *ifname, int *noise); |              Get current noise value. | **[in] radio**: interface name<br> **[in] noise**: value in dBm |
| int (*get_band_noise)(const char *ifname, enum wifi_band band, int *noise); |              Get current noise value. | **[in] radio**: interface name<br> **[in] radio**: band    radio band<br> **[in] noise**: value in dBm |
| int (*acs)(const char *name, struct acs_param *p) |              Trigger ACS (auto channel selection). | **[in] radio**: interface name<br> **[in] ACS**: request parameters |
| int (*get_param)(const char *name, const char *param, int *len, void *val) |              Get radio parameter value(s). | **[in] radio**: interface name<br> **[in] radio**: parameter name<br> **[in] length**: of the returned parameter value<br> **[in] parameter**: value |
| int (*set_param)(const char *name, const char *param, int len, void *val) |              Set radio parameter value(s). | **[in] radio**: interface name<br> **[in] radio**: parameter name<br> **[in] length**: of the parameter<br> **[in] value**: of parameter |
| int (*get_hwaddr)(const char *name, uint8_t *hwaddr) |              Get macaddress of the radio | **[in] radio**: interface name<br> **[in] mac**: address as an hex array |
| int (*add_iface)(const char *name, enum wifi_mode m, char *argv[]) |              Create a WiFi interface on this radio. | **[in] radio**: interface name<br> **[in] wifi**: mode f.e. WIFI_MODE_AP, WIFI_MODE_STA etc.<br> **[in] string**: arguments array of wifi attributes and values |
| int (*del_iface)(const char *name, const char *ifname) |              Delete a WiFi interface on this radio. | **[in] radio**: interface name<br> **[in] wifi**: interface name to be deleted |
| int (*list_iface)(const char *name, struct iface_entry *iface, int *num) |              List a WiFi interface on this radio. | **[in] radio**: interface name<br> **[in] array**: of interfaces<br> **[in] number**: of entries in iface array |
| int (*channels_info)(const char *name, struct chan_entry *channel, int *num) |              Get current channels info. | **[in] radio**: interface name<br> **[in] array**: of channels<br> **[in] number**: of entries in channel array |
| int (*channels_info_band)(const char *name, enum wifi_band band, struct chan_entry *channel, int *num) |              Get current channels info. | **[in] radio**: interface name<br> **[in] radio**: band    radio band<br> **[in] array**: of channels<br> **[in] number**: of entries in channel array |
| int (*start_cac)(const char *name, int channel, enum wifi_bw bw, |              Start CAC (channel availability check). | **[in] radio**: interface name<br> **[in] control**: channel control channel on which CAC is requested<br> **[in] bandwidth**:  *	@param[in] bw      bandwidth<br> **[in] CAC**: method  CAC method requested |
| int (*stop_cac)(const char *name, uint32_t channel, enum wifi_bw bw) |              Stop CAC. | **[in] radio**: interface name<br> **[in] use**: this channel when continous CAC<br> **[in] bandwidth**: when continous CAC |
| int (*get_opclass_preferences)(const char *name, struct wifi_opclass *opclass, |               Get prefered opclass/channels | **[in] radio**: interface name<br> **[in] array**: of opclass/channels<br> **[in] number**: of entries in opclass array |
| int (*get_band_opclass_preferences)(const char *name, enum wifi_band band, |               Get prefered opclass/channels | **[in] radio**: interface name<br> **[in] radio**: band     radio band<br> **[in] array**: of opclass/channels<br> **[in] number**: of entries in opclass array |
## Wi-Fi Interface Operations
| Function Signature | Description | Parameters |
|--------------------|-------------|------------|
| int (*simulate_radar)(const char *name, struct wifi_radar_args *radar) |  WiFi interface related operations. | **[in] radio**: interface name<br> **[in] simulated**: radar   simulated radar parameters |
| int (*start_wps)(const char *ifname, struct wps_param wps) |              Start WPS registration | **[in] interface**: name  interface name<br> **[in] wps_param**: structure |
| int (*stop_wps)(const char *ifname) |              Stop ongoing WPS registration | **[in] interface**: name  interface name |
| int (*get_wps_status)(const char *ifname, enum wps_status *s) |              Get latest wps registration status | **[in] interface**: name  interface name<br> **[in] wps_param**: structure |
| int (*get_wps_pin)(const char *ifname, unsigned long *pin) |              Get AP's (i.e. own) WPS pin | **[in] interface**: name  interface name<br> **[in] wps**: pin    wps pin value |
| int (*set_wps_pin)(const char *ifname, unsigned long pin) |              Set AP's (i.e. own) WPS pin | **[in] interface**: name  interface name<br> **[in] wps**: pin     wps pin value |
| int (*get_wps_device_info)(const char *ifname, struct wps_device *s) |              Get WPS device information | **[in] interface**: name  interface name<br> **[in] wps_device**: structure |
| int (*get_caps)(const char *ifname, struct wifi_caps *caps) |              Get capabilities | **[in] interface**: name  interface name<br> **[in] wifi_caps**: structure |
| int (*get_mode)(const char *ifname, enum wifi_mode *mode) |              Get WiFi mode | **[in] interface**: name  interface name<br> **[in] WiFi**: mode   WiFi mode f.e. WIFI_MODE_AP or WIFI_MODE_STA etc. |
| int (*get_security)(const char *ifname, uint32_t *auth, uint32_t *enc) |              Get security info | **[in] interface**: name  interface name<br> **[in] authtication**: type<br> **[in] encryption**: type |
| int (*add_vendor_ie)(const char *ifname, struct vendor_iereq *req) |              Add vendor specific ie element | **[in] interface**: name  interface name<br> **[in] vendor_iereq**: structure |
| int (*del_vendor_ie)(const char *ifname, struct vendor_iereq *req) |              Delete vendor specific ie element | **[in] interface**: name  interface name<br> **[in] vendor_iereq**: structure |
| int (*get_vendor_ies)(const char *ifname, struct vendor_ie *ies, int *num_ies) |              Get list of vendor information elements | **[in] interface**: name  interface name<br> **[in] array**: of struct vendor_ie<br> **[in] array**: size (number of elements) |
| int (*get_param)(const char *ifname, const char *param, int *len, void *val) |              Get AP parameter value(s). | **[in] interface**: name  interface name<br> **[in] parameter**: name<br> **[in] length**: of the returned value<br> **[in] parameter**: value |
| int (*set_param)(const char *ifname, const char *param, int len, void *val) |              Set AP parameter value(s). | **[in] interface**: name  interface name<br> **[in] parameter**: name<br> **[in] length**: of the parameter<br> **[in] value**: of parameter |
| int (*vendor_cmd)(const char *ifname, uint32_t vid, uint32_t subcmd, |              Vendor specific command | **[in] interface**: name  interface name<br> **[in] vendor**: id     vendor id (OUI)<br> **[in] (sub)command**:  *	@param[in] subcmd  (sub)command<br> **[in] input**: parameter<br> **[in] length**: of the input parameter<br> **[out] output**: parameter<br> **[out] length**: of the output parameter |
| int (*subscribe_frame)(const char *ifname, uint8_t type, uint8_t stype) |              Subscribe for received frames | **[in] interface**: name    interface name<br> **[in] frame**: type    frame type as in IEEE802.11 Std.<br> **[in] frame**: sub-type as in IEEE802.11 Std. |
| int (*unsubscribe_frame)(const char *ifname, uint8_t type, uint8_t stype) |              Unsubscribe for received frames | **[in] interface**: name    interface name<br> **[in] frame**: type    frame type as in IEEE802.11 Std.<br> **[in] frame**: sub-type as in IEEE802.11 Std. |
| int (*send_action_frame)(const char *ifname, struct wifi_frame_arg *arg, |              Send frame | **[in] interface**: name    interface name<br> **[in] send**: frame arguments viz. channel, rate, no-ack etc.<br> **[in] frame**: body<br> **[in] frame**: length including header.<br> **[in] cookie**: of the send frame operation. |
| int (*set_4addr)(const char *ifname, bool enable) |              Enable or disable 4-address mode. | **[in] interface**: name  interface name<br> **[in] enable**: = 1, else disable. |
| int (*get_4addr)(const char *ifname, bool *enabled) |              Get status of 4-address mode. | **[in] interface**: name  interface name<br> **[in] enabled**: = true, else disabled. |
| int (*get_4addr_parent)(const char *ifname, char *parent) |              Get parent interface of a 4-address mode interface. | **[in] interface**: name  interface name which is in 4-address mode<br> **[in] parent**: interface name. |
| int (*set_vlan)(const char *ifname, struct vlan_param vlan) |              Set VLAN link. | **[in] interface**: name  interface name<br> **[in] vlan**: parameters |
| int (*ap_info)(const char *ifname, struct wifi_ap *ap) |              Get detailed AP information | **[in] interface**: name  interface name<br> **[in] ap**: information |
| int (*ap_info_band)(const char *ifname, enum wifi_band band, struct wifi_ap *ap) |              Get detailed AP information | **[in] interface**: name  interface name<br> **[in] band**:  *	@param[in] band    band<br> **[in] ap**: information |
| int (*get_bssid)(const char *ifname, uint8_t *bssid) |              Get BSSID | **[in] interface**: name  interface name<br> **[in] BSSID**: buffer (6 bytes) |
| int (*get_ssid)(const char *ifname, char *ssid) |              Get SSID | **[in] interface**: name  interface name<br> **[in] SSID**: buffer |
| int (*get_stats)(const char *ifname, struct wifi_ap_stats *s) |              Get statistics | **[in] interface**: name  interface name<br> **[in] wifi_ap_stats**: structure |
| int (*get_beacon_ies)(const char *ifname, uint8_t *ies, int *len) |              Get Beacon frame information elements | **[in] interface**: name  interface name<br> **[in] information**: elements buffer<br> **[in] length**: of information elements buffer |
| int (*get_beacon_ies_band)(const char *ifname, enum wifi_band badn, uint8_t *ies, int *len) |              Get Beacon frame information elements | **[in] interface**: name  interface name<br> **[in] band**:  *	@param[in] band    band<br> **[in] information**: elements buffer<br> **[in] length**: of information elements buffer |
| int (*get_assoclist)(const char *ifname, uint8_t *stas, int *num_stas) |              Get STA association list | **[in] interface**: name  interface name<br> **[in] macaddresses**: of STAs<br> **[in] number**: of STAs |
| int (*get_assoclist_band)(const char *ifname, enum wifi_band band, uint8_t *stas, int *num_stas) |              Get STA association list | **[in] interface**: name  interface name<br> **[in] band**:  *	@param[in] band    band<br> **[in] macaddresses**: of STAs<br> **[in] number**: of STAs |
| int (*get_sta_info)(const char *ifname, uint8_t *addr, struct wifi_sta *info) |              Get STA information | **[in] interface**: name  interface name<br> **[in] macaddress**: of STA<br> **[in] STA**: information |
| int (*get_sta_info)(const char *ifname, enum wifi_band band, uint8_t *addr, struct wifi_sta *info) |              Get STA information | **[in] interface**: name  interface name<br> **[in] band**:  *	@param[in] band    band<br> **[in] macaddress**: of STA<br> **[in] STA**: information |
| int (*get_sta_stats)(const char *ifname, uint8_t *addr, struct wifi_sta_stats *s) |              Get STA statistics | **[in] interface**: name  interface name<br> **[in] macaddress**: of STA<br> **[in] STA**: counters |
| int (*disconnect_sta)(const char *ifname, uint8_t *sta, uint16_t reason) |              Disconnect STA | **[in] interface**: name  interface name<br> **[in] macaddress**: of STA<br> **[in] disconnect**: reason  disconnect reason code as in IEEE802.11 Std |
| int (*restrict_sta)(const char *ifname, uint8_t *sta, int enable) |              Assoc-control STA | **[in] interface**: name  interface name<br> **[in] macaddress**: of STA<br> **[in] enable**: (= 1) or disable (= 0) assoc-control |
| int (*block_sta)(const char *ifname, enum wifi_band band, uint8_t *sta, int block) |              Assoc-control STA | **[in] interface**: name  interface name<br> **[in] band**:  *	@param[in] band    band<br> **[in] macaddress**: of STA<br> **[in] block**: (= 1) or unblock (= 0) |
| int (*get_blocked_stas)(const char *ifname, enun wifi_band band, uint8_t *stas, int *num_stas) |              Assoc-control stations | **[in] interface**: name  interface name<br> **[in] band**:  *	@param[in] band    band<br> **[in] macaddresses**: of STAs<br> **[in] number**: of STAs |
| int (*monitor_sta)(const char *ifname, uint8_t *sta, struct wifi_monsta_config *cfg) |              Monitor STA frames | **[in] interface**: name  interface name<br> **[in] macaddress**: of STA<br> **[in] monitor**: STA config |
| int (*get_monitor_sta)(const char *ifname, uint8_t *sta, struct wifi_monsta *sta) |              Get monitored STA information | **[in] interface**: name  interface name<br> **[in] macaddress**: of STA<br> **[in] wifi_monsta**: structure |
| int (*get_monitor_stas)(const char *ifname, struct wifi_monsta *stas, int *num) |              Get monitored STA information | **[in] interface**: name  interface name<br> **[in] array**: of struct wifi_monsta<br> **[in] array**: size (number of wifi_monsta elements) |
| int (*probe_sta)(const char *ifname, uint8_t *sta) |              Probe STA's connection status | **[in] interface**: name  interface name<br> **[in] macaddress**: of STA |
| int (*add_neighbor)(const char *ifname, struct nbr nbr) |              Add a 802.11k neighbor entry | **[in] interface**: name  interface name<br> **[in] nbr**: structure |
| int (*del_neighbor)(const char *ifname, unsigned char *bssid) |              Delete a 802.11k neighbor entry | **[in] interface**: name  interface name<br> **[in] Bssid**: of the neighbor |
| int (*get_neighbor_list)(const char *ifname, struct nbr *nbr, int *nr) |              Get 802.11k neighbor list | **[in] interface**: name  interface name<br> **[in] array**: of struct nbr<br> **[in] number**: of array entries |
| int (*req_beacon_report)(const char *ifname, uint8_t *sta) |              Request 802.11k Beacon Report from a STA | **[in] interface**: name  interface name<br> **[in] macaddress**: of the STA<br> **[in] 11k**: beacon request parameters<br> **[in] actual**: size of param |
| int (*get_beacon_report)(const char *ifname, uint8_t *sta, |              Get 802.11k Beacon Report received from a STA | **[in] interface**: name  interface name<br> **[in] macaddress**: of the STA<br> **[in] array**: of sta_nbr structures<br> **[in] number**: of array entries |
| int (*req_bss_transition)(const char *ifname, unsigned char *sta, |              [Deprecated] Request 802.11v BSS transition to a STA | **[in] interface**: name  interface name<br> **[in] macaddress**: of the STA<br> **[in] number**: of neighbor bssids<br> **[in] array**: of neighbor bssids<br> **[in] timeout**: (secs) until this request is valid |
| int (*req_btm)(const char *ifname, unsigned char *sta, |              Request 802.11v BSS transition to a STA | **[in] interface**: name  interface name<br> **[in] macaddress**: of the STA<br> **[in] number**: of neighbor bssids<br> **[in] array**: of neighbors<br> **[in] additional**: request parameters |
| int (*get_11rkeys)(const char *ifname, unsigned char *sta, uint8_t *r1khid) |              Get 802.11r keys | **[in] interface**: name  interface name<br> **[in] macaddress**: of the STA<br> **[in] R1KHID**:  *	@param[out] rikhid:  R1KHID |
| int (*set_11rkeys)(const char *ifname, struct fbt_keys *fk) |              Set 802.11r keys | **[in] interface**: name  interface name<br> **[in] fbt_keys**: struct |
| int (*chan_switch)(const char *ifname, struct chan_switch_param *param) |              Send CSA and attempt to switch channel | **[in] interface**: name  interface name<br> **[in] channel**: switch announcement parameters |
| int (*mbo_disallow_assoc)(const char *ifname, uint8_t reason) |              Configure MBO assoc disallow | **[in] interface**: name  interface name<br> **[in] reason**: of blocking, check wifi_mbo_disallow_assoc_reason |
| int (*ap_set_state)(const char *ifname, bool up) |              Enable AP interface | **[in] interface**: name  interface name<br> **[in] interface**: up      interface up or down |
| int (*link_measure)(const char *ifname, uint8_t *sta) |              Send a RRM Link Measurement Request to STA | **[in] interface**: name  interface name<br> **[in] macaddress**: of the STA |
| int (*get_mlo_links)(const char *ifname, enum wifi_band band, |               Get MLO links we have inside netdev. | **[in] interface**: name   interface name<br> **[in] requested/used**: band     requested/used band<br> **[in] table**: of wifi_mlo_link<br> **[in] array**: size, number of mlo links |
| int (*get_ctrl_interface)(const char *ifname, char **ctrl_interface) |               Get hostapd/wpa_supplicant ctrl_interface file name from ifname. | **[in] interface**: name   interface name<br> **[in] ctrl_interface**: file |
| int (*get_ctrl_interface_band)(const char *ifname, enum wifi_band band, char **ctrl_interface) |               Get hostapd/wpa_supplicant ctrl_interface file name from ifname. | **[in] interface**: name   interface name<br> **[in] band**:  *	@param[in] ifname   band<br> **[in] ctrl_interface**: file |
| int (*sta_info)(const char *ifname, struct wifi_sta *sta) |              Get detailed STA information | **[in] interface**: name  interface name<br> **[in] STA**: information |
| int (*mlsta_interface_info)(const char *ifname, struct wifi_mlsta *mlsta) |              Get detailed MLSTA/STA information | **[in] interface**: name  interface name<br> **[in] STA**: information |
| int (*sta_get_stats)(const char *ifname, struct wifi_sta_stats *s) |              Get STA interface statistics | **[in] interface**: name  interface name<br> **[in] STA**: interface statistics |
| int (*sta_get_ap_info)(const char *ifname, struct wifi_bss *info) |              Get BSS information of the STA's AP | **[in] interface**: name  interface name<br> **[in] BSS**: information of STA's AP |
| int (*sta_disconnect_ap)(const char *ifname, uint32_t reason) |              Disconnect from STA's AP | **[in] interface**: name  interface name<br> **[in] disconnection**: reason  disconnection reason code as in IEEE802.11 Std. |
