#include <stdlib.h>
#include "libpicoevent.h"

pe_stream_t *pe_stream_new(int fd) {
	pe_stream_t *s = (pe_stream_t *) calloc( sizeof(pe_stream_t), 1);
	s->fd = fd;
	return s;
}

int pe_stream_get_fd(pe_stream_t *s) {
	return s->fd;
}

void *pe_stream_get_handler(pe_stream_t *s) {
	return s->event_handler;
}

// Register a handler for events arriving through
// a stream.
// Args: _self         = Pointer to a stream allocated with stream_new()
//       maxEventSize  = Size of events the event handler can cope
//       event_handler = Function pointer to callback
void pe_stream_add_handler(pe_stream_t *s, int maxEventSize, void (*event_handler)(pe_stream_t *stream, pe_event_t *event)) {

	if(maxEventSize > 0) {
		s->maxEventSize = maxEventSize;
		if(s->maxEventSize > (int) PE_MAX_EVENT_SIZE) s->maxEventSize = PE_MAX_EVENT_SIZE; 
	}

	s->event_handler = event_handler;
	
	return;
}

void pe_stream_remove_handler(pe_stream_t *s, void (*event_handler)(pe_stream_t *stream, pe_event_t *event)) {
	if(s->event_handler == event_handler) {
		s->event_handler = NULL;
	}

	return;
}


