#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>

#include "libpicoevent.h"

struct list_t {
	struct list_t *prev;
	struct list_t *next;
	void (*p)(void *arg);
};

pe_list_t *pe_list_new(void) {
	pe_list_t * head = (pe_list_t *) calloc(1, sizeof(pe_list_t));

	head->first = NULL;
	head->last = NULL;
	head->count = 0;
	pthread_mutex_init(&(head->lock), NULL);

	return head;
}

/* Objects are added to the end of the list */
void pe_list_add(pe_list_t *head, void * p) {
	struct list_t * new_last, * last;

	new_last = (struct list_t*) calloc(1, sizeof(struct list_t));

	pthread_mutex_lock(&(head->lock));
	new_last->p = p;

	if ( head->last ) {
		/* We already have an object in the list */
		last = head->last;
		last->next = new_last;
		new_last->prev = last;
		
	} else {
		/* This object is added to an empty list */
		head->first = new_last;
	}
	
	head->last = new_last;
	head->count++;
	pthread_mutex_unlock(&(head->lock));
	
	return;
}

void pe_list_delete(pe_list_t *head, void * p) {
	struct list_t * obj, * prev, * next;

	pthread_mutex_lock(&(head->lock));
	if ( head->count == 0 ) {
		pthread_mutex_unlock(&(head->lock));
		return;
	}
	
	obj = head->first;
	
	/* Loop over all objects in list */
	for (;;) {

		if ( obj->p == p ) {

			/* We have found our object */
			if ( ! obj->prev && obj->next ) {
				/* Object is at start of list with object follwing */
				next = obj->next;
				next->prev = NULL;
				head->first = next;
			} else if ( obj->prev && obj->next ) {
				/* Object in middle of list */
				next = obj->next;
				prev = obj->prev;
				next->prev = prev;
				prev->next = next;
			} else if ( ! obj->next && obj->prev ) {
				/* Object is at end of list with an object before it */
				prev = obj->prev;
				prev->next = NULL;
				head->last = prev;
			} else if ( ! obj->prev && ! obj->next ) {
				/* Object is only object in the list */
				head->first = NULL;
				head->last = NULL;
			}

			free(obj);
			head->count--;
			break;
		}

		if ( obj->next ) {
			/* Next object in list */
			obj = obj->next;
		} else {
			/* End of list */
			break;
		}
	}
	pthread_mutex_unlock(&(head->lock));
	return;
}

void *pe_list_get(pe_list_t *head) {
	struct list_t *obj, *next;
	void *content;

	pthread_mutex_lock(&(head->lock));
	if ( head->count == 0 ) {
		pthread_mutex_unlock(&(head->lock));
		return NULL;
	}
	
	obj = head->first;

	if ( ! obj->prev && obj->next ) {
		/* Object is at start of list with object follwing */
		next = obj->next;
		next->prev = NULL;
		head->first = next;
	} else if ( ! obj->prev && ! obj->next ) {
		/* Object is only object in the list */
		head->first = NULL;
		head->last = NULL;
	} else {
		printf("pe_list_get: something is messed up...\n");
		content = NULL;
	}

	content = obj->p;
	free(obj);
	head->count--;
	pthread_mutex_unlock(&(head->lock));

	return content;
}

void pe_list_call_each(pe_list_t *head, void * arg) {
	struct list_t *obj;

	pthread_mutex_lock(&(head->lock));
	if ( head->count == 0 ) {
		pthread_mutex_unlock(&(head->lock));		
		return;
	}
	obj = head->first;

	/* Loop over all objects in list */
	for (;;) {
		obj->p(arg);
		
		if ( obj->next ) {
			/* Next object in list */
			obj = obj->next;
		} else {
			/* End of list */
			break;
		}
	}
	pthread_mutex_unlock(&(head->lock));
	return;
}

// Iterate through list and let broker decide if object has been found.
void *pe_list_find(pe_list_t *head, int (*broker)(void*)) {
	struct list_t *obj;
	int res;

	if(!head || !broker) return NULL;
	pthread_mutex_lock(&(head->lock));
	if ( head->count == 0 ) {
		pthread_mutex_unlock(&(head->lock));
		return NULL;
	}
	obj = head->first;

	/* Loop over all objects in list */
	for (;;) {
		res = broker(obj->p);
		if(res) break;

		if ( obj->next ) {
			/* Next object in list */
			obj = obj->next;
		} else {
			/* End of list */
			break;
		}
	}
	pthread_mutex_unlock(&(head->lock));
	return (res ? obj->p : NULL);
}
