#include <unistd.h>
#include <stdlib.h>
#include <stdint.h>

#include "libpicoevent.h"

pe_event_t *pe_event_new(pe_stream_t *stream) {
	pe_event_t *e = (pe_event_t *) calloc(1, sizeof(pe_event_t));
	if (!e) err_exit("calloc");

	if(stream->maxEventSize > 0) {
		e->in = (uint8_t *) malloc(stream->maxEventSize);
		if (!e->in) err_exit("malloc");
	
		e->count = read(pe_stream_get_fd(stream), e->in, stream->maxEventSize);
	}
	return e;
}

void pe_event_destroy(pe_event_t *e) {
	free(e->in);
	free(e);
}

uint8_t * pe_event_data(pe_event_t *e) {
	return e->in;
}

int pe_event_count(pe_event_t *e) {
	return e->count;
}
