#include <sys/epoll.h>
#include <stdlib.h>
#include <errno.h>

#include "libpicoevent.h"

#define MAX_EVENTS 10

int pe_base_new(void) {
	return epoll_create1(0);
}

int pe_base_add_stream(int fd, pe_stream_t *stream) {
	struct epoll_event ev;

	ev.events = EPOLLIN;
	ev.data.ptr = stream;

	return epoll_ctl(fd, EPOLL_CTL_ADD, pe_stream_get_fd(stream), &ev);
}

int pe_base_delete_stream(int fd, pe_stream_t *stream) {
	return epoll_ctl(fd, EPOLL_CTL_DEL, pe_stream_get_fd(stream), NULL);
}

void pe_base_dispatch(int fd) {
	int nfds, i;
	struct epoll_event events[MAX_EVENTS];
	void (*stream_handler) (pe_stream_t *stream, pe_event_t *event);
	pe_stream_t *stream;
	pe_event_t *event;

	for(;;) {
		nfds = epoll_wait(fd, events, MAX_EVENTS, -1);
		if (nfds == -1 && errno != EINTR) {
			exit_failure("epoll_wait");
		}

		for (i = 0; i < nfds; ++i) {
			if (events[i].data.ptr) {
				/* Get stream object */
				stream = events[i].data.ptr;
				/* Get stream handler */
				stream_handler = pe_stream_get_handler(stream);
				/* Read data on fd */
				event = pe_event_new(stream);
				/* Dispatch event to stream handler */
				stream_handler(stream, event);
				pe_event_destroy(event);
			}
		}
	}
}
