/*
 * debug.h - debug utility functions
 *
 * Copyright (C) 2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * See LICENSE file for license related information.
 */
#ifndef LIBDPP_DEBUG_H
#define LIBDPP_DEBUG_H

#define ERR_LEVEL   (3)
#define WARN_LEVEL  (4)
#define INFO_LEVEL  (6)
#define DBG_LEVEL   (7)

#ifdef __cplusplus
extern "C" {
#endif

extern void dpp_log_stderr(int level, const char *fmt, ...);

#ifdef pr_error
#undef pr_error
#endif
#define pr_error(...)	dpp_log_stderr(ERR_LEVEL, __VA_ARGS__)

#ifdef pr_warn
#undef pr_warn
#endif
#define pr_warn(...)	dpp_log_stderr(WARN_LEVEL, __VA_ARGS__)

#ifdef pr_info
#undef pr_info
#endif
#define pr_info(...)	dpp_log_stderr(INFO_LEVEL, __VA_ARGS__)

#ifdef pr_debug
#undef pr_debug
#endif
#define pr_debug(...)	dpp_log_stderr(DBG_LEVEL, __VA_ARGS__)

#ifdef __cplusplus
}
#endif
#endif /* LIBDPP_DEBUG_H */
