# ieee1905d

[ieee1905d] (https://dev.iopsys.eu/iopsys/ieee1905.git)

## Introduction

This package implements the IEEE Std 1905.1-2013 and partly 1905.1a-2014.

It provides the following software components -

- `libieee1905.so` (shared library for 1905 TLVs and CMDU generation functions)
- `libmidgen.so` (shared library for generating message-ids for 1905 CMDUs)
- `ieee1905d` (user daemon implementing the 1905 stack and provides CLI for status and management)


Additionally, the package provides the following 1905 extension plugins -
- `map.so` (shared library for Multi-AP EasyMesh)
- `snoop.so` (dump all received 1905 CMUDs over UBUS, mainly for debugging)
- `topology.so` (build and show the full network topology)



## ieee1905d command line options

````bash
Usage: ieee1905d [-h | --help] [-v | --version] [options]

Options:

   -s <socket path>            path to UBUS socket used as CLI
   -D                          run as a daemon
   -R                          run in 1905 `Registrar` mode
   -c, --config <conf-file>    specify configuration file
   --alid <macaddress>         ALID for this instance
   --no-lo                     do not use 'lo' interface as a 1905 interface
   -d                          debug level; more 'd's mean more verbose
   -p <pidfile>                pid file path of this instance
   -l                          log to syslog
   -o <file>                   log to file
   -f                          treat above file as fifo for rolling logs
````


### UCI Configuration

An example UCI configuration file for ieee1905 with two extensions a) Multi-AP EasyMesh plugin `map` and b) Full-Topology plugin `topology` enabled. The 'al-iface' config section shows that interfaces br-lan, and any starting with 'wl' and 'wds' are to be included as interfaces belonging to the AL-layer. If br-lan is of type bridge, then all enslaved interfaces within br-lan automatcially is also part of the AL-layer.
Additionally, the config 'ap' sections define AP credentials viz. SSID, Security and Keys for AP-autoconfiguration of Enrollee 1905 devices in the respective FreqBands 2.4GHz and 5 GHz:

````bash
config ieee1905 'ieee1905'
        option enabled '1'
        option extension '1'
	list extmodule 'map'
	list extmodule 'topology'
        option macaddress 'aa:aa:aa:10:20:30'
        option registrar '2 5'

config ap
        option band '2'
        option ssid 'TestSSID.2'
        option encryption 'psk2'
        option key '1234567890'

config ap
        option band '5'
        option ssid 'TestSSID.5'
        option encryption 'psk2'
        option key '1234567890'

config al-iface
        option ifname 'br-lan'
        option ifname '/wl.*'
        option ifname '/wds.*'
````

Section | Name | Type | Required | Default | Description
--------|------|------|----------|---------|-------------
ieee1905 | - | - | - | - | - |
 "       |enabled | boolean | yes | 1 | When set to 0, disables the 1905 stack|
 "       |extension | boolean | no | 0 | When set to 1, allows extension of the 1905 stack through plugins |
 "       |extmodule | string | no | 0 | Specifies name of the extension plugin to lookup, load and start. Example plugin are 'map', 'topology', 'snoop'. |
 "       |macaddress | MAC address | no | auto | Specifies the 1905 AL macaddress. This can be set to any valid locally administered macaddress or 'auto' for a randomly generated one. |
 "       |registrar | list | no | (none) | List of frequency bands for which the 1905 in this device can act as a WSC Registrar. Possible values are: 2, 5. |
 "       |manufacturer | string | no | "IOPSYS" | Manufacturer name of this 1905 device. |
 "       |model_name | string | no | "1905-SampleDev" | Model name of this 1905 device. |
 "       |device_name | string | no | "1905Device" | Friendly name of this 1905 device. |
 "       |primary_vid| integer | no | 0 | Primary VLAN ID to be used for sending/receiving 802.1Q tagged CMDUs. |
 "       |exclude_tagging | string | no | (none) | Interface name which should not tag CMDUs. This field can take regex interface names when prefixed with ':' or '/'. Example - "/eth.\*" |
al-iface | - | - | - | - | - |
 "       |enabled | boolean | yes | 1 | When set to 0, disables the 'al-iface' config section. |
 "       | ifname | string | no | | Specifies the name of the interface that will be part of the 1905 AL. If 'ifname' is a bridge interface, then all enslaved interfaces of the bridge will be part of the 1905 AL. Starting with version 8.3.0, 'ifname' can be passed as regular expression. For example, set 'ifname' to "/wlan.\*" or ":wlan.\*" to include all interfaces starting with 'wlan'. NOTE: a regex 'ifname' must be prefixed with either ':' or '/' to differentiate it from non-regex 'ifname'. |
ap       | - | - | - | - | - |
 "       | band | integer | yes | (none) | Specifies the frequency band for which this AP configuration is applicable. The value here must be one of the values from 'registrar' list. Possible values are: 2, 5. |
 "       | ssid | string | yes | (none) | Specifies the SSID of the AP that can be auto-configured in this frequency band. |
 "       | encryption | string | yes | psk2 | Specifies the encryption type of the AP that can be auto-configured in this frequency band. |
 "       | key | string | yes | (none) | When encryption type is 'psk2', specifies the passphrase of the AP that can be auto-configured in this frequency band. |

-----------

UCI configuration for ieee1905d running in Registrar mode in bands 2.4 and 5:

````bash
config ieee1905 'ieee1905'
        option enabled '1'
        option registrar '2 5'
	option primary_vid '101'
	option manufacturer 'ABC Inc.'
	option model_name 'SmartDevice'
	option device_name 'SD123'
	option model_number '123.456.001'
	option serial_number '1234567890.001'
	option os_version '230005'

config ap
        option band '2'
        option ssid 'TestSSID.2'
        option encryption 'psk2'
        option key '1234567890'

config ap
        option band '5'
        option ssid 'TestSSID.5'
        option encryption 'psk2'
        option key '1234567890'

config al-iface
        option enabled 1
````

After ieee1905d is started with the above config, interfaces that are to be
managed and treated as 1905 interfaces can be added at runtime through the
`add_interface` method of `ieee1905` UBUS object.

Conversely, `del_interface` can be used to remove an interface from the 1905 AL.

### UBUS Objects and APIs

The 1905 daemon publishes the `ieee1905` object over UBUS.

````bash
root@iopsys:~# ubus -v list ieee1905
'ieee1905' @1d99fac8
        "id":{}
        "log":{"feature":"String","level":"Integer"}
        "start":{}
        "stop":{}
        "status":{}
        "info":{}
        "neighbors":{}
        "links":{}
        "others":{}
        "arptable":{}
        "apconfig":{"ifname":"String","band":"Integer","action":"String"}
        "refresh":{}
        "cmdu":{"dst":"String","src":"String","type":"Integer","mid":"Integer","vid":"Integer","data":"String","ifname":"String"}
        "buildcmdu":{"type":"Integer","ifname":"String","args":"Array"}
        "rxcmdu":{"src":"String","ifname":"String","type":"String","mid":"Integer","data":"String"}
        "add_interface":{"ifname":"String"}
        "del_interface":{"ifname":"String"}
        "vlan":{"vid":"Integer"}
        "frag_scheme":{"dst":"String","mode":"Integer"}
````

Per-interface UBUS objects corresponding to the 1905 AL interfaces are also
created -

````bash
root@iopsys:~# ubus -v list ieee1905.al.*
'ieee1905.al.ifname1' @eb801e37
        "status":{}
        "neighbors":{}
        "cmdu":{"dst":"String","src":"String","type":"Integer","mid":"Integer","data":"String"}

'ieee1905.al.ifname2' @eb801e37
        "status":{}
        "neighbors":{}
        "cmdu":{"dst":"String","src":"String","type":"Integer","mid":"Integer","data":"String"}
````

When the package is built with 1905 CMDU extension support enabled, then the following `ieee1905.extension`
object is created. This extension object provides CLI methods through which an extension plugin can be
dynamically loaded, unloaded, started or stopped.

````bash
root@iopsys:~# ubus -v list ieee1905.extension
'ieee1905.extension' @d3d28211
        "load":{"name":"String"}
        "unload":{"name":"String"}
        "start":{"name":"String"}
        "stop":{"name":"String"}
        "list":{}
````

**Multi-AP Plugin**

The Multi-AP plugin implements 1905 CMDUs and extensions as required by the Wi-Fi
Alliance's Multi-AP EasyMesh specification.

After the Multi-AP plugin (**map.so**) is loaded through `ieee1905.extension`'s **load**
ubus method, a new UBUS object corresponding to the MAP plugin `ieee1905.map` is
published.

````bash
root@iopsys:~# ubus -v list ieee1905.map
'ieee1905.map' @1cd3d8ae
        "register":{"module":"String","data":"String"}
````

Through the `ieee1905.map` object's **register** method, Multi-AP client applications
viz. mapagent, mapcontroller, decollector etc. can register themselves and be able
to receive, process and transmit EasyMesh Multi-AP CMDUs.

**Topology Plugin**

The Topology extension plugin `topology.so` builds the full topology of connected 1905 and non-1905 devices in the network.

The topology plugin publishes a new UBUS object `ieee1905.topology` providing the following method to dump the full network topology -

````bash
root@iopsys:~# ubus -v list ieee1905.topology
'ieee1905.topology' @1cd3d8ae
        "dump":{}    # dumps detailed information about the 1905 nodes and their connections
        "show":{}    # simple view showing the 1905 nodes and their connections
````

## Code structure ##

The source code is within the `src` directory.

Files within the `src` directory -

*1905_tlvs.h* - defines IEEE-1905 CMDU types and TLV data structures.

*cmdu.c,h* - CMDU buffer manipulation functions reside in these files.

*policy.c* - defines TLV policies and CMDU parsing according to the defined policies.

*i1905.c,h* - files define data structures and implement functions used by the 1905 daemon.

*config.c,h* - for 1905 configuration related structures and functions.

*cmdu_input.c* - processing of the received CMDUs are in this c file.

*cmdu_output.c* - creation of CMDUs for transmit are implemented in this file

*genmid.c* - this source file implements generation of CMDU message-ids.

*bufutil.h,c* - defines and implements helper functions for unaligned buffer manipulation.

*i1905_extension.c,h* - implements functions needed for registering and working with 1905 extension plugins.

*neigh.c,h* - for managing directly connected network neighbor devices.

*i1905_netlink.c* - implements rtnetlink events handling.

*i1905_cmd.c* - CLI commands supported by the running ieee1905d instance.
*i1905_cmdresp.c* - CLI commands implementation.

*i1905_ubus.c* - UBUS objects and methods used as CLI are implemented in this file.

*main.c* - includes the main() entry point for the ieee1905d daemon.

*cryptutil.c,h* - defines and implements cryptographic functions needed by IEEE-1905.

*i1905_wsc.c,h* - defines structures and implements WSC M1 and M2 message generation functions.

*i1905_dm.c,h* - these files define and implement the IEEE-1905 DataModel as per TR-181.

*debug.c,h* - contain functions used for debugging and logging.

*hlist.h
util.c,h
timer.c,h
timer_impl.h* - these files implement utility and helper functions used by the ieee1905d daemon.

*cmdu\_ackq.c,h* - implements timer-queue for transmit CMDUs awaiting either some response or acknowledgement.

*cmduqueue.c* - implements queueing functions for CMDUs.


**extmodules**

extmodules/map - contains Multi-AP extension plugin.

*extmodules/map/easymesh.h* - header file defining Multi-AP EasyMesh TLVs and CMDU types.
extmodules/map/r1.c
extmodules/map/r2.c
extmodules/map/r3.c
extmodules/map/r4.c
extmodules/map/policy.c* - files implementing Multi-AP EasyMesh TLVs policies and parsing functions.

*extmodules/map/map.c* - main file implementing the 1905 plugin extension for Multi-AP.

*extmodule/map/map_module.c* - provide interfaces through which Multi-AP client applications can register and receive CMDUs of interest. Examples of Multi-AP client applications include EasyMesh Agent, EasyMesh Controller and such.

*extmodules/map/tests/mapclient1.c,
extmodules/map/tests/mapclient2.c* - dummy Multi-AP client applications showing how the Multi-AP 'map.so' plugin can be used.

**tests**

*fuzz* - this directory contains components that can be used for fuzzing test.

**scripts**

*docker* - contains Dockerfiles and related scripts to build and run 1905 docker images.


## Dependencies ##

To successfully build ieee1905d, the following libraries are needed:

| Dependency  		| Link                                       						| License        |
| -----------------	| ----------------------------------------------------------------			| -------------- |
| libeasy	  	| https://dev.iopsys.eu/hal/libeasy.git							| LGPL 2.1       |
| libwifi	  	| https://dev.iopsys.eu/hal/libwifi.git							| LGPL 2.1       |
| libuci      		| https://git.openwrt.org/project/uci.git     					 	| LGPL 2.1       |
| libubox     		| https://git.openwrt.org/project/libubox.git 					 	| ISC            |
| libblobmsg_json	| https://git.openwrt.org/project/libubox.git						| ISC		 |
| libubus     		| https://git.openwrt.org/project/ubus.git    					 	| LGPL 2.1       |
| libjson-c   		| https://s3.amazonaws.com/json-c_releases    					 	| MIT            |
| libnl-3	  	| https://github.com/thom311/libnl.git							| LGPLv2.1	 |
| libnl-genl-3  	| https://github.com/thom311/libnl.git                                            	| LGPLv2.1       |
| libnl-route-3  	| https://github.com/thom311/libnl.git                                            	| LGPLv2.1       |

