#!/bin/bash

echo "install dependencies"

home=$(pwd)

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1
	local ret=$?

	if [ "${ret}" -ne 0 ]; then
		echo "Failed to execute $@ ret (${ret})"
		exit 1
	fi
}

exec_cmd apt update
exec_cmd apt install -y iproute2

# wifimngr
cd /opt/dev
rm -fr wifimngr
exec_cmd git clone -b devel https://dev.iopsys.eu/iopsys/wifimngr.git
cd wifimngr
exec_cmd ./gitlab-ci/install-dependencies.sh
exec_cmd ./gitlab-ci/setup.sh
exec_cmd cmake .
exec_cmd make
exec_cmd cp wifimngr /usr/sbin/

# bbfdm
[ -d "/opt/dev/bbfdm" ] && rm -rf /opt/dev/bbfdm
if [ -n "${BBFDM_BRANCH}" ]; then
	exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
else
	exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
fi
cd /opt/dev/bbfdm
./gitlab-ci/install-dependencies.sh install
./gitlab-ci/setup.sh install
