// SPDX-License-Identifier: BSD-3-Clause
/*
 * tlv_checker.h - EasyMesh TLV data validation functions header file.
 *
 * Copyright (C) 2024 IOPSYS Software Solutions AB. All rights reserved.
 * Copyright (C) 2025 Genexis AB.
 *
 * Author: anjan.chanda@iopsys.eu
 */

#ifndef TLV_CHECKER_H
#define TLV_CHECKER_H

#include <stdint.h>

#define DECL(t)	int validate_ ## t(const uint8_t *data, size_t datalen)

DECL(TLV_TYPE_WSC);
DECL(TLV_TYPE_VENDOR_SPECIFIC);

DECL(MAP_TLV_SUPPORTED_SERVICE);
DECL(MAP_TLV_SEARCHED_SERVICE);
DECL(MAP_TLV_AP_RADIO_IDENTIFIER);
DECL(MAP_TLV_AP_OPERATIONAL_BSS);
DECL(MAP_TLV_ASSOCIATED_CLIENTS);
DECL(MAP_TLV_AP_CAPABILITY);
DECL(MAP_TLV_AP_RADIO_BASIC_CAPABILITIES);
DECL(MAP_TLV_AP_HT_CAPABILITIES);
DECL(MAP_TLV_AP_VHT_CAPABILITIES);
DECL(MAP_TLV_AP_HE_CAPABILITIES);
DECL(MAP_TLV_STEERING_POLICY);
DECL(MAP_TLV_METRIC_REPORTING_POLICY);
DECL(MAP_TLV_CHANNEL_PREFERENCE);
DECL(MAP_TLV_RADIO_OPERATION_RESTRICTION);
DECL(MAP_TLV_TRANSMIT_POWER_LIMIT);
DECL(MAP_TLV_CHANNEL_SELECTION_RESPONSE);
DECL(MAP_TLV_OPERATING_CHANNEL_REPORT);
DECL(MAP_TLV_CLIENT_INFO);
DECL(MAP_TLV_CLIENT_CAPABILITY_REPORT);
DECL(MAP_TLV_CLIENT_ASSOCIATION_EVENT);
DECL(MAP_TLV_AP_METRIC_QUERY);
DECL(MAP_TLV_AP_METRICS);
DECL(MAP_TLV_STA_MAC_ADDRESS);
DECL(MAP_TLV_ASSOCIATED_STA_LINK_METRICS);
DECL(MAP_TLV_UNASSOCIATED_STA_LINK_METRICS_QUERY);
DECL(MAP_TLV_UNASSOCIATED_STA_LINK_METRICS_RESPONSE);
DECL(MAP_TLV_BEACON_METRICS_QUERY);
DECL(MAP_TLV_BEACON_METRICS_RESPONSE);
DECL(MAP_TLV_STEERING_REQUEST);
DECL(MAP_TLV_STEERING_BTM_REPORT);
DECL(MAP_TLV_CLIENT_ASSOCIATION_CONTROL_REQUEST);
DECL(MAP_TLV_BACKHAUL_STEERING_REQUEST);
DECL(MAP_TLV_BACKHAUL_STEERING_RESPONSE);
DECL(MAP_TLV_HIGHER_LAYER_DATA);
DECL(MAP_TLV_ASSOCIATED_STA_TRAFFIC_STATS);
DECL(MAP_TLV_ERROR_CODE);
DECL(MAP_TLV_CHANNEL_SCAN_REPORTING_POLICY);
DECL(MAP_TLV_CHANNEL_SCAN_CAPABILITY);
DECL(MAP_TLV_CHANNEL_SCAN_REQ);
DECL(MAP_TLV_CHANNEL_SCAN_RES);
DECL(MAP_TLV_TIMESTAMP);
#if (EASYMESH_VERSION >= 3)
DECL(MAP_TLV_1905_SECURITY_CAPS);
DECL(MAP_TLV_AP_WIFI6_CAPS);
DECL(MAP_TLV_MIC);
DECL(MAP_TLV_ENCRYPTED_PAYLOAD);
#endif /* >= 3 */
DECL(MAP_TLV_CAC_REQ);
DECL(MAP_TLV_CAC_TERMINATION);
DECL(MAP_TLV_CAC_COMPLETION_REPORT);
#if (EASYMESH_VERSION >= 3)
DECL(MAP_TLV_ASSOCIATED_WIFI6_STA_STATUS);
#endif /* >= 3 */
DECL(MAP_TLV_CAC_STATUS_REPORT);
DECL(MAP_TLV_CAC_CAPABILITY);
DECL(MAP_TLV_MULTIAP_PROFILE);
DECL(MAP_TLV_PROFILE2_AP_CAPABILITY);
DECL(MAP_TLV_DEFAULT_8021Q_SETTINGS);
DECL(MAP_TLV_TRAFFIC_SEPARATION_POLICY);
#if (EASYMESH_VERSION >= 3)
DECL(MAP_TLV_BSS_CONFIGURATION_REPORT);
DECL(MAP_TLV_BSSID);
DECL(MAP_TLV_SERVICE_PRIORITIZATION_RULE);
DECL(MAP_TLV_DSCP_MAPPING_TABLE);
DECL(MAP_TLV_BSS_CONFIGURATION_REQUEST);
#endif /* >= 3 */
DECL(MAP_TLV_PROFILE2_ERR_CODE);
#if (EASYMESH_VERSION >= 3)
DECL(MAP_TLV_BSS_CONFIGURATION_RESPONSE);
#endif /* >= 3 */
DECL(MAP_TLV_AP_RADIO_ADV_CAPABILITY);
DECL(MAP_TLV_ASSOCIATION_STATUS_NOTIF);
DECL(MAP_TLV_SOURCE_INFO);
DECL(MAP_TLV_TUNNELED_MSG_TYPE);
DECL(MAP_TLV_TUNNELED);
DECL(MAP_TLV_PROFILE2_STEERING_REQ);
DECL(MAP_TLV_UNSUCCESS_ASSOCIATION_POLICY);
DECL(MAP_TLV_METRIC_COLLECTION_INTERVAL);
DECL(MAP_TLV_RADIO_METRICS);
DECL(MAP_TLV_AP_EXTENDED_METRICS);
DECL(MAP_TLV_ASSOCIATED_STA_EXT_LINK_METRICS);
DECL(MAP_TLV_STATUS_CODE);
DECL(MAP_TLV_REASON_CODE);
DECL(MAP_TLV_BACKHAUL_STA_RADIO_CAPABILITY);
#if (EASYMESH_VERSION >= 3)
DECL(MAP_TLV_AKM_SUITE_CAPS);
DECL(MAP_TLV_1905_ENCAP_DPP);
DECL(MAP_TLV_1905_ENCAP_EAPOL);
DECL(MAP_TLV_DPP_BOOTSTRAP_URI_NOTIFICATION);
#endif /* >= 3 */
DECL(MAP_TLV_BACKHAUL_BSS_CONFIG);
#if (EASYMESH_VERSION >= 3)
DECL(MAP_TLV_DPP_MESSAGE);
DECL(MAP_TLV_DPP_CCE_INDICATION);
DECL(MAP_TLV_DPP_CHIRP_VALUE);
DECL(MAP_TLV_DEVICE_INVENTORY);
DECL(MAP_TLV_AGENT_LIST);
#endif /* >= 3 */
#if (EASYMESH_VERSION >= 4)
DECL(MAP_TLV_ANTICIPATED_CHANNEL_PREF);
DECL(MAP_TLV_ANTICIPATED_CHANNEL_USAGE);
DECL(MAP_TLV_SPATIAL_REUSE_REQUEST);
DECL(MAP_TLV_SPATIAL_REUSE_REPORT);
DECL(MAP_TLV_SPATIAL_REUSE_CONFIG_RESPONSE);
DECL(MAP_TLV_QOS_MANAGEMENT_POLICY);
DECL(MAP_TLV_QOS_MANAGEMENT_DESCRIPTOR);
DECL(MAP_TLV_CONTROLLER_CAPS);
#endif /* >= 4 */
#if (EASYMESH_VERSION >= 6)
DECL(MAP_TLV_WIFI7_AGENT_CAPABILITIES);
DECL(MAP_TLV_AP_MLD_CONFIG);
DECL(MAP_TLV_BACKHAUL_STA_MLD_CONFIG);
DECL(MAP_TLV_STA_MLD_CONFIG);
DECL(MAP_TLV_MLD_STRUCTURE);
DECL(MAP_TLV_AFFILIATED_STA_METRICS);
DECL(MAP_TLV_AFFILIATED_AP_METRICS);
DECL(MAP_TLV_TID_TO_LINK_MAPPING_POLICY);
DECL(MAP_TLV_EHT_OPERATIONS);
#endif /* >= 6 */

#endif /* TLV_CHECKER_H */
