#!/bin/bash

echo "install dependencies"

home=$(pwd)

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1
	local ret=$?

	if [ "${ret}" -ne 0 ]; then
		echo "Failed to execute $@ ret (${ret})"
		exit 1
	fi
}

exec_cmd apt update
exec_cmd apt install -y iproute2

# libwifi-*.so + libeasy.so
rm -fr libeasy
mkdir -p /usr/include/easy
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/libeasy.git
cd libeasy
exec_cmd cmake .
exec_cmd make CFLAGS+="-I/usr/include/libnl3"
exec_cmd mkdir -p /usr/include/easy
exec_cmd cp easy.h event.h utils.h if_utils.h debug.h hlist.h bufutil.h cryptutil.h ecc_cryptutil.h timestamp.h /usr/include/easy
exec_cmd cp -a libeasy*.so* /usr/lib

cd /opt/dev
rm -fr libwifi
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/libwifi.git
cd libwifi
exec_cmd make WIFI_TYPE=TEST CFLAGS+="-DHAS_WIFI=1"
exec_cmd cp wifidefs.h wifiutils.h wifiops.h wifi.h /usr/include
exec_cmd cp -a libwifi*.so* /usr/lib

# wifimngr
cd /opt/dev
rm -fr wifimngr
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/wifimngr.git
cd wifimngr
exec_cmd ./gitlab-ci/install-dependencies.sh
exec_cmd ./gitlab-ci/setup.sh
exec_cmd make
exec_cmd cp wifimngr /usr/sbin/

# bbfdm
[ -d "/opt/dev/bbfdm" ] && rm -rf /opt/dev/bbfdm
if [ -n "${BBFDM_BRANCH}" ]; then
	exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
else
	exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
fi
cd /opt/dev/bbfdm
./gitlab-ci/install-dependencies.sh install
./gitlab-ci/setup.sh install
