# Datamodel mappings for Device.IEEE1905.

IEEE1905 datamodel object provides details about the self-node in 'Device.IEEE1905.AL.' Object and it shows the first hop connected IEEE1905 devices in 'Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.{i}.' Object.

For any 3rd party application like NMS/GUI/UI which wants to show the network topology, has to cross reference between different tables to show the complete network topology.

Since, this has been now under discussion in Broadband forum, we added support to show the self-node in the NetworkTopology as well.

Following is an example of an easymesh setup, in this 
the self-node:
**Device.IEEE1905.AL.IEEE1905Id => 46:d4:37:71:b5:00**

Can also be seen in NetworkTopology:
**Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Id => 46:d4:37:71:b5:00**

```bash
root@eagle-44d43771b500:~# bbfdmd -c get Device.IEEE1905.
Device.IEEE1905.Version => 1905.1a
Device.IEEE1905.AL.IEEE1905Id => 46:d4:37:71:b5:00
Device.IEEE1905.AL.Status => Enabled
Device.IEEE1905.AL.RegistrarFreqBand => 802.11 5 GHz,802.11 2.4 GHz,802.11 60 GHz
Device.IEEE1905.AL.Security.SetupMethod => PBC
Device.IEEE1905.AL.Security.Password => 
Device.IEEE1905.AL.NetworkingRegistrar.Registrar2dot4 => 00:00:00:00:00:00
Device.IEEE1905.AL.NetworkingRegistrar.Registrar5 => 00:00:00:00:00:00
Device.IEEE1905.AL.NetworkingRegistrar.Registrar60 => 00:00:00:00:00:00
Device.IEEE1905.AL.InterfaceNumberOfEntries => 9
Device.IEEE1905.AL.Interface.1.InterfaceId => 44:d4:37:71:b5:01
Device.IEEE1905.AL.Interface.1.Status => Up
Device.IEEE1905.AL.Interface.1.LowerLayers => Device.Ethernet.Interface.1
Device.IEEE1905.AL.Interface.1.MediaType => IEEE 802.3ab
Device.IEEE1905.AL.Interface.1.PowerState => On
Device.IEEE1905.AL.Interface.1.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.1.LinkNumberOfEntries => 1
Device.IEEE1905.AL.Interface.1.Link.1.InterfaceId => 44:d4:37:71:b4:11
Device.IEEE1905.AL.Interface.1.Link.1.IEEE1905Id => 46:d4:37:71:b4:10
Device.IEEE1905.AL.Interface.1.Link.1.MediaType => IEEE 802.3ab
Device.IEEE1905.AL.Interface.1.Link.1.Metric.IEEE802dot1Bridge => 1
Device.IEEE1905.AL.Interface.1.Link.1.Metric.PacketErrors => 0
Device.IEEE1905.AL.Interface.1.Link.1.Metric.PacketErrorsReceived => 0
Device.IEEE1905.AL.Interface.1.Link.1.Metric.TransmittedPackets => 2059
Device.IEEE1905.AL.Interface.1.Link.1.Metric.PacketsReceived => 0
Device.IEEE1905.AL.Interface.1.Link.1.Metric.MACThroughputCapacity => 0
Device.IEEE1905.AL.Interface.1.Link.1.Metric.PHYRate => 0
Device.IEEE1905.AL.Interface.1.Link.1.Metric.RSSI => 255
Device.IEEE1905.AL.Interface.2.InterfaceId => 44:d4:37:71:b5:01
Device.IEEE1905.AL.Interface.2.Status => Up
Device.IEEE1905.AL.Interface.2.LowerLayers => Device.Ethernet.Interface.2
Device.IEEE1905.AL.Interface.2.MediaType => IEEE 802.3ab
Device.IEEE1905.AL.Interface.2.PowerState => On
Device.IEEE1905.AL.Interface.2.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.2.LinkNumberOfEntries => 0
Device.IEEE1905.AL.Interface.3.InterfaceId => 44:d4:37:71:b5:0f
Device.IEEE1905.AL.Interface.3.Status => Up
Device.IEEE1905.AL.Interface.3.LowerLayers => Device.WiFi.Radio.1
Device.IEEE1905.AL.Interface.3.MediaType => IEEE 802.11ax 5.0
Device.IEEE1905.AL.Interface.3.PowerState => On
Device.IEEE1905.AL.Interface.3.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.3.LinkNumberOfEntries => 0
Device.IEEE1905.AL.Interface.4.InterfaceId => 3e:d4:37:71:b5:08
Device.IEEE1905.AL.Interface.4.Status => Up
Device.IEEE1905.AL.Interface.4.LowerLayers => Device.WiFi.Radio.1
Device.IEEE1905.AL.Interface.4.MediaType => IEEE 802.11ax 5.0
Device.IEEE1905.AL.Interface.4.PowerState => On
Device.IEEE1905.AL.Interface.4.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.4.LinkNumberOfEntries => 0
Device.IEEE1905.AL.Interface.5.InterfaceId => 44:d4:37:71:b5:0e
Device.IEEE1905.AL.Interface.5.Status => Up
Device.IEEE1905.AL.Interface.5.LowerLayers => Device.WiFi.Radio.2
Device.IEEE1905.AL.Interface.5.MediaType => IEEE 802.11ax 2.4
Device.IEEE1905.AL.Interface.5.PowerState => On
Device.IEEE1905.AL.Interface.5.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.5.LinkNumberOfEntries => 0
Device.IEEE1905.AL.Interface.6.InterfaceId => 3a:d4:37:71:b5:0f
Device.IEEE1905.AL.Interface.6.Status => Up
Device.IEEE1905.AL.Interface.6.LowerLayers => Device.WiFi.Radio.2
Device.IEEE1905.AL.Interface.6.MediaType => IEEE 802.11ax 2.4
Device.IEEE1905.AL.Interface.6.PowerState => On
Device.IEEE1905.AL.Interface.6.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.6.LinkNumberOfEntries => 0
Device.IEEE1905.AL.Interface.7.InterfaceId => 44:d4:37:71:b5:00
Device.IEEE1905.AL.Interface.7.Status => Down
Device.IEEE1905.AL.Interface.7.LowerLayers => 
Device.IEEE1905.AL.Interface.7.MediaType => IEEE 802.3u
Device.IEEE1905.AL.Interface.7.PowerState => On
Device.IEEE1905.AL.Interface.7.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.7.LinkNumberOfEntries => 0
Device.IEEE1905.AL.Interface.8.InterfaceId => 44:d4:37:71:b5:00
Device.IEEE1905.AL.Interface.8.Status => Down
Device.IEEE1905.AL.Interface.8.LowerLayers => 
Device.IEEE1905.AL.Interface.8.MediaType => IEEE 802.3u
Device.IEEE1905.AL.Interface.8.PowerState => On
Device.IEEE1905.AL.Interface.8.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.8.LinkNumberOfEntries => 0
Device.IEEE1905.AL.Interface.9.InterfaceId => 44:d4:37:71:b5:02
Device.IEEE1905.AL.Interface.9.Status => Up
Device.IEEE1905.AL.Interface.9.LowerLayers => Device.Ethernet.Interface.3
Device.IEEE1905.AL.Interface.9.MediaType => IEEE 802.3u
Device.IEEE1905.AL.Interface.9.PowerState => On
Device.IEEE1905.AL.Interface.9.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.Interface.9.LinkNumberOfEntries => 0
Device.IEEE1905.AL.ForwardingTable.SetForwardingEnabled => 0
Device.IEEE1905.AL.ForwardingTable.ForwardingRuleNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.Enable => 1
Device.IEEE1905.AL.NetworkTopology.Status => Available
Device.IEEE1905.AL.NetworkTopology.MaxChangeLogEntries => 100
Device.IEEE1905.AL.NetworkTopology.LastChange => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905DeviceNumberOfEntries => 2
Device.IEEE1905.AL.NetworkTopology.ChangeLogNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Id => 46:d4:37:71:b5:00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Version => 1905.1a
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.FriendlyName => 1905Device
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.ManufacturerName => IOPSYS
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.ManufacturerModel => 1905-SampleDev
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.ControlURL => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv4AddressNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6AddressNumberOfEntries => 4
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.InterfaceNumberOfEntries => 9
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.NonIEEE1905NeighborNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905NeighborNumberOfEntries => 1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.L2NeighborNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.BridgingTupleNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.1.MACAddress => 44:d4:37:71:b5:0f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.1.IPv6Address => fe80::46d4:37ff:fe71:b50f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.1.IPv6AddressType => Unknown
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.1.IPv6AddressOrigin => ::
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.2.MACAddress => 3e:d4:37:71:b5:08
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.2.IPv6Address => fe80::3cd4:37ff:fe71:b508
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.2.IPv6AddressType => Unknown
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.2.IPv6AddressOrigin => ::
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.3.MACAddress => 44:d4:37:71:b5:0e
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.3.IPv6Address => fe80::46d4:37ff:fe71:b50e
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.3.IPv6AddressType => Unknown
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.3.IPv6AddressOrigin => ::
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.4.MACAddress => 3a:d4:37:71:b5:0f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.4.IPv6Address => fe80::38d4:37ff:fe71:b50f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.4.IPv6AddressType => Unknown
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IPv6Address.4.IPv6AddressOrigin => ::
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1.InterfaceId => 44:d4:37:71:b5:01
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1.MediaType => IEEE 802.3ab
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.2.InterfaceId => 44:d4:37:71:b5:01
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.2.MediaType => IEEE 802.3ab
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.2.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.2.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.2.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.2.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.2.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.2.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3.InterfaceId => 44:d4:37:71:b5:0f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3.MediaType => IEEE 802.11ax 5.0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3.NetworkMembership => 44:d4:37:71:b5:0f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3.Role => AP
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3.APChannelBand => 02
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3.FrequencyIndex1 => 74
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3.FrequencyIndex2 => 28
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4.InterfaceId => 3e:d4:37:71:b5:08
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4.MediaType => IEEE 802.11ax 5.0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4.NetworkMembership => 3e:d4:37:71:b5:08
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4.Role => AP
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4.APChannelBand => 02
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4.FrequencyIndex1 => 74
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4.FrequencyIndex2 => 28
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5.InterfaceId => 44:d4:37:71:b5:0e
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5.MediaType => IEEE 802.11ax 2.4
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5.NetworkMembership => 44:d4:37:71:b5:0e
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5.Role => AP
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5.APChannelBand => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5.FrequencyIndex1 => 0b
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5.FrequencyIndex2 => 28
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6.InterfaceId => 3a:d4:37:71:b5:0f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6.MediaType => IEEE 802.11ax 2.4
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6.NetworkMembership => 3a:d4:37:71:b5:0f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6.Role => AP
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6.APChannelBand => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6.FrequencyIndex1 => 0b
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6.FrequencyIndex2 => 28
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.7.InterfaceId => 44:d4:37:71:b5:00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.7.MediaType => IEEE 802.3u
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.7.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.7.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.7.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.7.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.7.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.7.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.8.InterfaceId => 44:d4:37:71:b5:00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.8.MediaType => IEEE 802.3u
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.8.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.8.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.8.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.8.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.8.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.8.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.9.InterfaceId => 44:d4:37:71:b5:02
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.9.MediaType => IEEE 802.3u
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.9.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.9.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.9.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.9.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.9.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.9.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.LocalInterface => Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.NeighborDeviceId => 46:d4:37:71:b4:10
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.MetricNumberOfEntries => 1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.NeighborMACAddress => 44:d4:37:71:b4:11
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.IEEE802dot1Bridge => 1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.PacketErrors => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.PacketErrorsReceived => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.TransmittedPackets => 2059
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.PacketsReceived => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.MACThroughputCapacity => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.LinkAvailability => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.PHYRate => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.IEEE1905Neighbor.1.Metric.1.RSSI => 255
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.BridgingTuple.1.InterfaceList => Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.1,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.3,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.4,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.5,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.1.Interface.6
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Id => 46:d4:37:71:b4:10
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Version => 1905.1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.FriendlyName => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.ManufacturerName => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.ManufacturerModel => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.ControlURL => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.VendorPropertiesNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IPv4AddressNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IPv6AddressNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.InterfaceNumberOfEntries => 8
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.NonIEEE1905NeighborNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905NeighborNumberOfEntries => 1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.L2NeighborNumberOfEntries => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.BridgingTupleNumberOfEntries => 1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1.InterfaceId => 44:d4:37:71:b4:11
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1.MediaType => IEEE 802.3ab
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2.InterfaceId => 7e:d4:37:71:b4:18
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2.MediaType => IEEE 802_11AX
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3.InterfaceId => 7e:d4:37:71:b4:19
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3.MediaType => IEEE 802_11AX
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4.InterfaceId => 7a:d4:37:71:b4:1f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4.MediaType => IEEE 802_11AX
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5.InterfaceId => 7a:d4:37:71:b4:10
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5.MediaType => IEEE 802_11AX
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.6.InterfaceId => 44:d4:37:71:b4:10
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.6.MediaType => IEEE 802.3u
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.6.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.6.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.6.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.6.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.6.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.6.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.7.InterfaceId => 44:d4:37:71:b4:1f
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.7.MediaType => IEEE 802.3ab
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.7.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.7.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.7.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.7.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.7.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.7.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.8.InterfaceId => 44:d4:37:71:b4:1e
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.8.MediaType => IEEE 802.3ab
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.8.PowerState => On
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.8.NetworkMembership => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.8.Role => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.8.APChannelBand => 
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.8.FrequencyIndex1 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.8.FrequencyIndex2 => 00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.LocalInterface => Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.NeighborDeviceId => 46:d4:37:71:b5:00
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.MetricNumberOfEntries => 1
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.NeighborMACAddress => 44:d4:37:71:b4:11
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.IEEE802dot1Bridge => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.PacketErrors => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.PacketErrorsReceived => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.TransmittedPackets => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.PacketsReceived => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.MACThroughputCapacity => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.LinkAvailability => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.PHYRate => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.IEEE1905Neighbor.1.Metric.1.RSSI => 0
Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.BridgingTuple.1.InterfaceList => Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.1,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.2,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.3,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.4,Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.2.Interface.5
```
