# tr069 UBUS Schema

```
https://www.iopsys.eu/tr069.json
```

| Custom Properties | Additional Properties |
| ----------------- | --------------------- |
| Forbidden         | Forbidden             |

# tr069

| List of Methods     |
| ------------------- |
| [command](#command) | Method | tr069 (this schema) |
| [inform](#inform)   | Method | tr069 (this schema) |
| [status](#status)   | Method | tr069 (this schema) |

## command

### Ubus method to define cwmp client action

`command`

- type: `Method`

### command Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property  | Type   | Required     |
| --------- | ------ | ------------ |
| `command` | string | **Required** |

#### command

CWMP supported commands

`command`

- is **required**
- type: reference

##### command Type

`string`

The value of this property **must** be equal to one of the [known values below](#command-known-values).

##### command Known Values

| Value              |
| ------------------ |
| reload             |

### Ubus CLI Example

```
ubus call tr069 command {"command":"reload"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "tr069", "command", { "command": "reload" }]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `info`   | string  | Optional     |
| `status` | integer | **Required** |

#### info

`info`

- is optional
- type: `string`

##### info Type

`string`

#### status

`status`

- is **required**
- type: `integer`

##### status Type

`integer`

### Output Example

```json
{ "status": -14386015, "info": "qui anim" }
```

## inform

### Ubus method to handle RPC

`inform`

- type: `Method`

### inform Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property        | Type    | Required |
| --------------- | ------- | -------- |
| `GetRPCMethods` | boolean | Optional |
| `event`         | string  | Optional |

#### GetRPCMethods

If enabled, sends GetRPCMethods to acs

`GetRPCMethods`

- is optional
- type: `boolean`

##### GetRPCMethods Type

`boolean`

#### event

CWMP ubus supported events

`event`

- is optional
- type: reference

##### event Type

`string`

The value of this property **must** be equal to one of the [known values below](#inform-known-values).

##### event Known Values

| Value                  |
| ---------------------- |
| 1 BOOT                 |
| 2 PERIODIC             |
| 3 SCHEDULED            |
| 4 VALUE CHANGE         |
| 6 CONNECTION REQUEST   |
| 8 DIAGNOSTICS COMPLETE |

### Ubus CLI Example

```
ubus call tr069 inform {"GetRPCMethods":true,"event":"8 DIAGNOSTICS COMPLETE"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "tr069", "inform", { "GetRPCMethods": true, "event": "8 DIAGNOSTICS COMPLETE" }]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type    | Required |
| -------- | ------- | -------- |
| `info`   | string  | Optional |
| `status` | integer | Optional |

#### info

`info`

- is optional
- type: `string`

##### info Type

`string`

#### status

`status`

- is optional
- type: `integer`

##### status Type

`integer`

### Output Example

```json
{ "status": 10889093, "info": "occaecat" }
```

## status

### Get CWMP running status

List down cwmp status with last session, next session and session statistics details

`status`

- type: `Method`

### status Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | **Required** |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Ubus CLI Example

```
ubus call tr069 status {}
```

### JSONRPC Example

```json
{ "jsonrpc": "2.0", "id": 0, "method": "call", "params": ["<SID>", "tr069", "status", {}] }
```

#### output

`output`

- is **required**
- type: `object`

##### output Type

`object` with following properties:

| Property       | Type   | Required     |
| -------------- | ------ | ------------ |
| `cwmp`         | object | **Required** |
| `last_session` | object | **Required** |
| `next_session` | object | **Required** |
| `statistics`   | object | **Required** |

#### cwmp

`cwmp`

- is **required**
- type: `object`

##### cwmp Type

`object` with following properties:

| Property     | Type   | Required     |
| ------------ | ------ | ------------ |
| `acs_url`    | string | **Required** |
| `start_time` | string | **Required** |
| `status`     | string | **Required** |

#### acs_url

`acs_url`

- is **required**
- type: `string`

##### acs_url Type

`string`

#### start_time

`start_time`

- is **required**
- type: `string`

##### start_time Type

`string`

#### status

`status`

- is **required**
- type: `string`

##### status Type

`string`

#### last_session

`last_session`

- is **required**
- type: `object`

##### last_session Type

`object` with following properties:

| Property     | Type   | Required     |
| ------------ | ------ | ------------ |
| `end_time`   | string | **Required** |
| `start_time` | string | **Required** |
| `status`     | string | **Required** |

#### end_time

`end_time`

- is **required**
- type: `string`

##### end_time Type

`string`

#### start_time

`start_time`

- is **required**
- type: `string`

##### start_time Type

`string`

#### status

`status`

- is **required**
- type: `string`

##### status Type

`string`

#### next_session

`next_session`

- is **required**
- type: `object`

##### next_session Type

`object` with following properties:

| Property     | Type   | Required     |
| ------------ | ------ | ------------ |
| `end_time`   | string | **Required** |
| `start_time` | string | **Required** |
| `status`     | string | **Required** |

#### end_time

`end_time`

- is **required**
- type: `string`

##### end_time Type

`string`

#### start_time

`start_time`

- is **required**
- type: `string`

##### start_time Type

`string`

#### status

`status`

- is **required**
- type: `string`

##### status Type

`string`

#### statistics

`statistics`

- is **required**
- type: `object`

##### statistics Type

`object` with following properties:

| Property           | Type    | Required     |
| ------------------ | ------- | ------------ |
| `failure_sessions` | integer | **Required** |
| `success_sessions` | integer | **Required** |
| `total_sessions`   | integer | **Required** |

#### failure_sessions

`failure_sessions`

- is **required**
- type: `integer`

##### failure_sessions Type

`integer`

- minimum value: `0`

#### success_sessions

`success_sessions`

- is **required**
- type: `integer`

##### success_sessions Type

`integer`

- minimum value: `0`

#### total_sessions

`total_sessions`

- is **required**
- type: `integer`

##### total_sessions Type

`integer`

- minimum value: `0`

### Output Example

```json
{
  "cwmp": { "status": "Ut ipsum in", "start_time": "esse id nostrud minim aliquip", "acs_url": "qui sit amet" },
  "last_session": {
    "status": "nisi dolor quis consectetur aliqua",
    "start_time": "sint exercitation dolor",
    "end_time": "commodo"
  },
  "next_session": { "status": "occaecat", "start_time": "officia", "end_time": "adipisicing" },
  "statistics": { "success_sessions": 97229034, "failure_sessions": 38595887, "total_sessions": 8351784 }
}
```
