#!/bin/bash

function log()
{
	echo "$*" >> ./funl-test-debug.log
	echo "$*"
}

function cleanup()
{
	echo ""
	supervisorctl stop all
	cp /var/log/supervisor/*.log .
}

function check_ret()
{
	ret=$1
	if [ "$ret" -ne 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function error_on_zero()
{
	ret=$1
	if [ "$ret" -eq 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit 1
	fi

}

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1

	if [ $? -ne 0 ]; then
		echo "Failed to execute $@"
		exit 1
	fi
}

function configure_acs()
{
	echo "Create a new ACS User"
	curl -X POST 'http://acs:3000/init' -H "Content-Type: application/json" --data '{"users": true, "presets": true, "filters": true, "device": true, "index": true, "overview": true}' >/dev/null 2>&1
	check_ret $?

	echo "Delete the default provision inform from ACS"
	curl -X DELETE 'http://acs:7557/provisions/inform' >/dev/null 2>&1
	check_ret $?

	echo "Add a new provision inform in ACS"
	curl -X PUT 'http://acs:7557/provisions/inform' --data-binary '@/tmp/connection_request_auth' >/dev/null 2>&1
	check_ret $?

	#echo "get the supported provisions"
	#curl -X GET 'http://acs:7557/provisions/'
	#check_ret $?

	#echo "Upload firmware image to ACS server"
	#exec_cmd dd if=/dev/zero of=/tmp/firmware_v1.0.bin bs=25MB count=1
	#echo "Valid" > /tmp/firmware_v1.0.bin
	#curl -X PUT 'http://localhost:7557/files/firmware_v1.0.bin' --data-binary '@/tmp/firmware_v1.0.bin' --header "fileType: 1 Firmware Upgrade Image" --header "oui: XXX" --header "productClass: FirstClass" --header "version: 000000001" >/dev/null 2>&1
	#check_ret $?
}

function check_cwmp_status()
{
	echo "icwmp status"
	iter=0
	state=0
	while [ $iter -lt 10 ]; do
		status=`ubus call tr069 status | jq -r ".cwmp.status"`
		if [ "${status}" == "up" ]; then
			state=1
			break
		fi

		iter=$(( $iter + 1))
		sleep 2
	done

	if [ $state -eq 0 ]; then
		echo "icwmpd is not started correctly, (the current status=${status})"
		exit 1
	fi
}

function clean_icwmp()
{
	if [ -d build ]; then
		rm -rf build
	fi

	exec_cmd make -C test/cmocka clean
	find -name '*.gcda' -exec rm {} -fv \;
	find -name '*.gcno' -exec rm {} -fv \;
	find -name '*.gcov' -exec rm {} -fv \;
	find -name '*.deps' -exec rm {} -rfv \;
	find -name '*.so' -exec rm {} -fv \;
	rm -f *.o *.log *.xml vgcore.* firmware_v1.0.bin
	rm -rf report
}

function build_icwmp()
{
	COV_CFLAGS='-g -O0 -fprofile-arcs -ftest-coverage'
	COV_LDFLAGS='--coverage'
	VENDOR_PREFIX='X_IOWRT_EU_'

	BINP="${PWD}"
	# clean icwmp
	clean_icwmp

	# compile icwmp
	mkdir -p build
	cd build
	cmake ../ -DCMAKE_C_FLAGS="$COV_CFLAGS -DICWMP_ENABLE_VENDOR_EXTN" -DCMAKE_EXE_LINKER_FLAGS="$COV_LDFLAGS" -DCMAKE_INSTALL_PREFIX=/ -DBBF_VENDOR_PREFIX="$VENDOR_PREFIX"
	exec_cmd make

	echo "installing icwmpd binary and libcwmpdm.so library"
	exec_cmd cp src/icwmpd ../src/
	exec_cmd cp bbf_plugin/libcwmpdm.so ../bbf_plugin/
	exec_cmd make install
	[ -f "/usr/sbin/icwmpd" ] && rm /usr/sbin/icwmpd
	exec_cmd ln -sf ${BINP}/src/icwmpd /usr/sbin/icwmpd
	exec_cmd ln -sf ${BINP}/bbf_plugin/libcwmpdm.so /usr/share/bbfdm/micro_services/icwmp.so
	cd ..
}

function install_bbfdmd()
{
	[ -d "/opt/dev/bbfdm" ] && rm -rf /opt/dev/bbfdm

	if [ -n "${BBFDM_BRANCH}" ]; then
		exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	else
		exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	fi

	cd /opt/dev/bbfdm
	exec_cmd ./gitlab-ci/install-dependencies.sh install
	exec_cmd ./gitlab-ci/setup.sh install
}

function check_valgrind_xml() {
	echo "Checking memory leaks..."
	cp /tmp/memory-report.xml memory-report.xml

	valgrind-ci memory-report.xml --summary
	exec_cmd valgrind-ci memory-report.xml --abort-on-errors
}
