/*
 * ubus_utils.h - ubus methods and utility functions
 *
 * Copyright (C) 2022, IOPSYS Software Solutions AB.
 *
 * Author: suvendhu.hansa@iopsys.eu
 *
 * See LICENSE file for license related information
 *
 */
#ifndef __ICWMP_UBUS_UTILS_H__
#define __ICWMP_UBUS_UTILS_H__

#include <libubus.h>
#include <libubox/blobmsg_json.h>
#include "common.h"

typedef void (*icwmp_ubus_cb)(struct ubus_request *req, int type, struct blob_attr *msg);
typedef void (*icwmp_ubus_async_cb)(struct ubus_request *req, int ret);
void bb_add_string(struct blob_buf *bb, const char *name, const char *value);
void icwmp_ubus_send_event(const char *event, const char *data);
int icwmp_ubus_invoke(const char *obj, const char *method, struct blob_attr *msg,
		      icwmp_ubus_cb icwmp_callback, void *callback_arg);
int icwmp_ubus_invoke_timeout(const char *obj, const char *method, struct blob_attr *msg,
			icwmp_ubus_cb icwmp_callback, void *callback_arg, int timeout);
int icwmp_ubus_invoke_async(const char *obj, const char *method, struct blob_attr *msg,
		      icwmp_ubus_cb data_callback, icwmp_ubus_async_cb complete_callback);
int icwmp_uloop_ubus_register(void);
void icwmp_uloop_ubus_exit(void);
int initiate_autonomous_complpolicy(void);
void clean_autonomous_complpolicy(void);
int initiate_interface_update(void);
void clean_interface_update(void);
int icwmp_connect_ubus(void);
int wait_for_bbf_object(void);
void icwmp_free_ubus(void);
#endif /* __ICWMP_UBUS_UTILS_H__ */
