/*
 * wifi_api.h - WiFi APIs
 *
 * Copyright (C) 2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef WIFI_API_H
#define WIFI_API_H

#include <wifidefs.h>

#ifdef HAS_WIFI
int is_wifi_interface(const char *ifname);
int is_ap_interface(const char *ifname);
int apmld_get_mlsta(const char *ifname, uint8_t *sta_macaddrs, struct wifi_mlsta *mlsta);
int ap_get_assoclist(const char *ifname, uint8_t *sta_macaddrs, int *num);
int interface_get_4addr_parent(const char *ifname, char *parent);
int is_affiliated_ap(const char *ifname);
#else
static inline int is_wifi_interface(const char *ifname)
{
	return 0;
}

static inline int is_ap_interface(const char *ifname)
{
	return -1;
}

static inline int apmld_get_mlsta(const char *ifname, uint8_t *sta_macaddrs, struct wifi_mlsta *mlsta)
{
	return -1;
}

static inline int ap_get_assoclist(const char *ifname, uint8_t *sta_macaddrs, int *num)
{
	return -1;
}

static inline int interface_get_4addr_parent(const char *ifname, char *parent)
{
	return -1;
}
static inline int is_affiliated_ap(const char *ifname)
{
	return -1;
}

#endif /* HAS_WIFI */

#endif /* WIFI_API_H */
