# Host Data Model Mapping

This document provides information about the mapping between the Host object and its corresponding backend.

In general, all parameters are 1-1 mapped with ubus `hosts->show->hosts[i]` output.

The table below illustrates the option names used for retrieving the value for each parameter.

| Parameter | Option | Comment |
| --------- | ------ | ------- |
| Device.Hosts.Host.{i}.PhysAddress | `macaddr` | Get the value directly from `macaddr` option |
| Device.Hosts.Host.{i}.IPAddress | `ipaddr` | Get the value directly from `ipaddr` option |
| Device.Hosts.Host.{i}.DHCPClient | `address_source` & `macaddr` | Check the value of `address_source`. If it's `DHCP`, use the `macaddr` value as a linker to get the DHCP Client reference; otherwise, return an empty value |
| Device.Hosts.Host.{i}.AssociatedDevice | `is1905` & `macaddr` & `link_macaddr` | Check the value of `is1905`. If `true`, use `link_macaddr` as a linker to get the WiFi Associated Device reference; otherwise, use `macaddr` as a linker |
| Device.Hosts.Host.{i}.Layer1Interface | `local` & `interface_type` & `is1905` & `device` & `parent_device` | Check the value of `local` first. If it's `false`, return an empty value; otherwise, continue to check the value of `interface_type`. If it's `Ethernet`, use `device` option as a linker to obtain the Ethernet Interface reference; otherwise, continue to check the value of `is1905`. If it's `true`, use `parent_device` as a linker to obtain the WiFi Radio reference; otherwise, use `device` as a linker |
| Device.Hosts.Host.{i}.Layer3Interface | `network` | Use the `network` value as a linker to get the IP Interface reference corresponding to the host |
| Device.Hosts.Host.{i}.InterfaceType | `interface_type` | Get the value directly from `interface_type` option |
| Device.Hosts.Host.{i}.HostName | `hostname` | Get the value directly from `hostname` option |
| Device.Hosts.Host.{i}.Active | `active` | Get the value directly from `active` option |
| Device.Hosts.Host.{i}.ActiveLastChange | `active_last_change` | Get the value directly from `active_last_change` option |
| Device.Hosts.Host.{i}.IPv4Address.{i}.IPAddress | `ipv4addr[i]` | Get the value directly from `ipv4addr[i]` option |
| Device.Hosts.Host.{i}.IPv6Address.{i}.IPAddress | `ipv6addr[i]` | Get the value directly from `ipv6addr[i]` option |
| Device.Hosts.Host.{i}.WANStats.BytesSent | `stats.tx_bytes` | Get the value directly from `stats.tx_bytes` option |
| Device.Hosts.Host.{i}.WANStats.BytesReceived | `stats.rx_bytes` | Get the value directly from `stats.rx_bytes` option |
| Device.Hosts.Host.{i}.WANStats.PacketsSent | `stats.tx_packets` | Get the value directly from `stats.tx_packets` option |
| Device.Hosts.Host.{i}.WANStats.PacketsReceived | `stats.rx_packets` | Get the value directly from `stats.rx_packets` option |
