
This document describes the `hostmngr` utility daemon that can detect and show
host devices in the network.

The term 'host devices' here refer to devices that must contain atleast one
network interface capable of being configured with IPv4/IPv6 address either via
DHCP or Static method.

Examples of host devices - desktop/laptop, router/AP, IP-camera, smart-TV etc.

## Build and build config ##

Run 'make' from within the "src" directory to build the 'hostmngr' utility
daemon. See **Dependencies** section for the prerequisites.

For install, run 'make install'. This will install 'hostmngr' to the default
install path at '/usr/sbin'.

Following config options may be passed during build to enable/disable certain
features or change the values from their default -

Enable and maintain history of host devices:

`CONFIG_HOSTMNGR_HOSTS_HISTORY=y`

Configure hostmngr to use libwifi APIs when target device has WiFi:

`HOSTMNGR_PLATFORM_HAS_WIFI=y`


## Configuration ##

The default configuration file is '/etc/config/hosts', which keeps the run-time
configuration for hostmngr.

Sample '/etc/config/hosts' file -

````bash
config global 'global'
	option enabled '1'
	option history '1'
	option history_reboot_persistent '1'
	option history_file '/etc/hosts_history.json'
	option history_timeout '604800'

config interface
	list ifname 'br-lan'

````
The format of the config file is UCI compliant.


Section | Name | Type | Required | Default | Description
--------|------|------|----------|---------|-------------
global | - | - | - | - | - |
 "       |enabled | boolean | no | 1 | When set to 0, disables hostmngr. The daemon will however keep running, and can be re-enabled by setting to 1. |
 "       |history| boolean | no | 1 | When set to 0, disables history. |
 "       |history_reboot_persistent| boolean | no | 1 | When set to 0, history entries are not persisted across reboots. |
 "       |history_file | string | no | '/etc/hosts_history.json' | Specifies history file name. History records are stored in this file in JSON format. |
 "       |history_timeout | integer | no | 604800 | Specifies the duration in seconds a _non-live_ history record will be kept in history. |
interface | - | - | - | - | - |
 "       | ifname | string | no | br-lan | Interface name over which hostmngr runs. Default is 'br-lan', which is the bridge interface facing the LAN side. This means hostmngr detects host devices in the LAN side. |

-----------

## CLI (through UBUS) ##

The hostmngr daemon provides UBUS methods through which user or any service
can interact with for fetching status and stats of the host devices in the network.

````bash
root@iopsys:~# ubus -v list hosts
'hosts' @1000ffff
	"show":{}
	"history":{}
	"debug":{}
````

Sample output of the 'ubus call hosts show' invocation -

````bash
root@eagle-44d43771baa0:~# ubus call hosts show
{
        "hosts": [
                {
                        "macaddr": "00:02:02:aa:bb:cc",
                        "hostname": "acx-laptop",
                        "active": true,
                        "active_last_change": "2023-05-30T21:31:57",
                        "ipaddr": "192.168.1.160",
                        "address_source": "DHCP",
                        "lease_time_remaining": 3369,
                        "interface_type": "Ethernet",
                        "is1905": false,
                        "link_macaddr": "",
                        "ndm_state": "reachable",
                        "num_tcp": 0,
                        "num_udp": 10,
                        "active_connections": 10,
                        "device": "eth3",
                        "network": "lan",
                        "ipv4_address": [
                                "ip": "192.168.1.160"
                        ],
                        "ipv6_address": [

                        ],
                        "stats": {
                                "tx_packets": 70,
                                "tx_bytes": 7323,
                                "rx_packets": 61,
                                "rx_bytes": 5860
                        }
                }
        ]
}
````

Sample output of the 'ubus call hosts history' -

````bash
root@eagle-44d43771baa0:~# ubus call hosts history
{
        "history": [
                {
                        "idx": 4,
                        "macaddr": "00:02:02:aa:bb:cc",
                        "hostname": "acx-laptop",
                        "first_seen": "2023-05-30T21:30:38",
                        "last_seen": "2023-05-30T21:31:57",
                        "alive": true,
                        "iswifi": false,
                        "stats": {
                                "tx_packets": 0,
                                "tx_bytes": 0,
                                "rx_packets": 0,
                                "rx_bytes": 0
                        }
                }
        ]
}
````

The value of **'alive'** changes to **false** when the host device is no longer
present in the network. A _non-live_ host device is one that is not present in the
network at that time.

## Dependencies ##

'hostmngr' requires the following components for build and runtime dependencies:

| Dependency  		| Link                                       						| License        |
| -----------------	| ----------------------------------------------------------------			| -------------- |
| libeasy	  	| https://dev.iopsys.eu/hal/libeasy.git							| LGPL 2.1       |
| libwifi	  	| https://dev.iopsys.eu/hal/libwifi.git							| LGPL 2.1       |
| libuci      		| https://git.openwrt.org/project/uci.git     					 	| LGPL 2.1       |
| libubox     		| https://git.openwrt.org/project/libubox.git 					 	| ISC            |
| libblobmsg_json	| https://git.openwrt.org/project/libubox.git						| ISC		 |
| libubus     		| https://git.openwrt.org/project/ubus.git    					 	| LGPL 2.1       |
| libjson-c   		| https://s3.amazonaws.com/json-c_releases    					 	| MIT            |
| libnl-3	  	| https://github.com/thom311/libnl.git							| LGPLv2.1	 |
| libnl-genl-3  	| https://github.com/thom311/libnl.git                                            	| LGPLv2.1       |
| libnl-route-3  	| https://github.com/thom311/libnl.git                                            	| LGPLv2.1       |
| libnetfilter_conntrack| https://git.netfilter.org/libnetfilter_conntrack					| GPLv2+         |
| libnfnetlink		| https://git.netfilter.org/libnfnetlink                                            	| GPLv2+         |
| libmnl		| https://git.netfilter.org/libmnl                                            		| LGPLv2.1       |



## Code structure ##

The source code is within the `src` directory.

Files within the `src` directory -

*topology.h* - defines hosts and network topology related data structures.

*hostmngr.c* - implements the hostmngr daemon.

*config.c,h* - for configuration related structures and functions.

*neigh.c,h* - for managing the connected host devices.

*netlink.c* - implements rtnetlink events handling.

*stats.c* - for IPv4/IPv6 connection statistics of the host devices.

*history.c* - includes functions for storing and loading history to/from history file.

*ubus.c* - implements UBUS objects and methods provided by hostmngr.

*wifi_api.c,h* - implements WiFi functions for target having HAS_WIFI=y.

*main.c* - includes the main() entry point for hostmngr daemon.

*debug.c,h* - contain functions used for debugging and logging.

*util.c,h
timer.c,h
timer_impl.h
lookup3_hash.c,h* - these files implement utility and helper functions.

