/*
 * useropts.h - user options while starting hostmngr.
 *
 * Copyright (C) 2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * See LICENSE file for license related information.
 *
 */


#ifndef USEROPTS_H
#define USEROPTS_H

/* default options */
#define HOSTS_CONFFILE                "hosts"
#define HOSTS_CONFFILE_PATH           "/etc/config"
#define HOSTS_OBJECT                  "hosts"
#define HOSTMNGR_PIDFILE              "/var/run/hostmngr.pid"
#define MAX_ALLOWED_EXCLUDE           10
#define MAX_ZONES                     8
#define MAX_IFNAMES                   8

struct hostmngr_useropts {
	const char *ubus_sockpath;
	const char *pidfile;
	const char *objname;
	bool daemonize;
	const char *conffile;
	const char *confpath;
	int debug_level;
	const char *logfile;
	bool logfile_isfifo;
	bool syslogging;
	const char *alid;
	bool lo;
	char *zone[MAX_ZONES];
	int num_zone;
	char *ifname[MAX_IFNAMES];
	int num_ifname;
	char *exclude_ifnames[MAX_ALLOWED_EXCLUDE];
	int num_exclude;
};


#define IEEE1905_OBJECT               "ieee1905"
#define IEEE1905_TOPOLOGY_OBJECT      IEEE1905_OBJECT".topology"


#endif /* USEROPTS_H */
