/*
 * lookup3_hash.h - header file for lookup3() hash.
 *
 * Ref: https://burtleburtle.net/bob/c/lookup3.c
 * by Bob Jenkins, May 2006, Public Domain.
 */

#include <stdint.h>

#ifndef LOOKUP3_HASH_H
#define LOOKUP3_HASH_H


extern uint32_t hashword(const uint32_t *k, size_t length, uint32_t initval);

extern void hashword2(const uint32_t *k, size_t length, uint32_t *pc, uint32_t *pb);

#endif /* LOOKUP3_HASH_H */
