#!/bin/bash

echo "install dependencies"

home=$(pwd)

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1
	local ret=$?

	if [ "${ret}" -ne 0 ]; then
		echo "Failed to execute $@ ret (${ret})"
		exit 1
	fi
}

exec_cmd apt update
exec_cmd apt install -y iproute2

# libwifi-*.so + libeasy.so
rm -fr libeasy
mkdir -p /usr/include/easy
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/libeasy.git
cd libeasy
exec_cmd make CFLAGS+="-I/usr/include/libnl3"
exec_cmd cp -a libeasy*.so* /usr/lib
exec_cmd cp -a easy.h event.h utils.h if_utils.h debug.h hlist.h bufutil.h cryptutil.h ecc_cryptutil.h timestamp.h /usr/include/easy/

cd /opt/dev
rm -fr libwifi
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/libwifi.git
cd libwifi
exec_cmd make HAS_WIFI=1 WIFI_TYPE=TEST
exec_cmd cp wifidefs.h wifiutils.h wifiops.h wifi.h /usr/include
exec_cmd cp -a libwifi*.so* /usr/lib

# wifimngr
cd /opt/dev
rm -fr wifimngr
exec_cmd git clone -b release-7.5 https://dev.iopsys.eu/iopsys/wifimngr.git
cd wifimngr
exec_cmd ./gitlab-ci/install-dependencies.sh
exec_cmd ./gitlab-ci/setup.sh
exec_cmd make
exec_cmd cp wifimngr /usr/sbin/

# libnfnetlink.so libmnl.so libnetfilter-conntrack.so
cd /opt/dev
rm -fr libnfnetlink*
rm -fr libmnl*
rm -fr libnetfilter_conntrack*
mkdir -p /usr/include/libnfnetlink
mkdir -p /usr/include/libmnl
mkdir -p /usr/include/libnetfilter_conntrack
mkdir -p /usr/include/libbbfdm-api
mkdir -p /usr/include/libbbfdm-api/version-2/

exec_cmd wget https://www.netfilter.org/projects/libnfnetlink/files/libnfnetlink-1.0.2.tar.bz2
exec_cmd bzip2 -d libnfnetlink-1.0.2.tar.bz2
exec_cmd tar -xvf libnfnetlink-1.0.2.tar

exec_cmd wget https://www.netfilter.org/projects/libmnl/files/libmnl-1.0.5.tar.bz2
exec_cmd bzip2 -d libmnl-1.0.5.tar.bz2
exec_cmd tar -xvf libmnl-1.0.5.tar

exec_cmd wget https://www.netfilter.org/projects/libnetfilter_conntrack/files/libnetfilter_conntrack-1.0.9.tar.bz2
exec_cmd bzip2 -d libnetfilter_conntrack-1.0.9.tar.bz2
exec_cmd tar -xvf libnetfilter_conntrack-1.0.9.tar


exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git

cd libnfnetlink-1.0.2
exec_cmd "./configure"
exec_cmd "make"
exec_cmd cp -a include/libnfnetlink/libnfnetlink.h /usr/include/libnfnetlink/
exec_cmd cp -a include/libnfnetlink/linux_nfnetlink.h /usr/include/libnfnetlink/
exec_cmd cp -a include/libnfnetlink/linux_nfnetlink_compat.h /usr/include/libnfnetlink/
exec_cmd cp -a src/.libs/libnfnetlink.so* /usr/lib/
exec_cmd cp -a src/.libs/libnfnetlink.la /usr/lib/

cd ../libmnl-1.0.5
exec_cmd "./configure"
exec_cmd "make"
exec_cmd cp -a include/libmnl/libmnl.h /usr/include/libmnl/
exec_cmd cp -a src/.libs/libmnl.so* /usr/lib/
exec_cmd cp -a src/.libs/libmnl.la /usr/lib/

cd ../libnetfilter_conntrack-1.0.9
exec_cmd export LIBNFNETLINK_CFLAGS=/usr/include/libnfnetlink/
exec_cmd export LIBNFNETLINK_LIBS=/usr/lib/
exec_cmd export LIBMNL_CFLAGS=/usr/include/libmnl/
exec_cmd export LIBMNL_LIBS=/usr/lib/
exec_cmd ./configure
exec_cmd "make"
exec_cmd cp -a include/libnetfilter_conntrack/libnetfilter_conntrack.h /usr/include/libnetfilter_conntrack/
exec_cmd cp -a include/libnetfilter_conntrack/linux_nfnetlink_conntrack.h /usr/include/libnetfilter_conntrack/
exec_cmd cp -a include/libnetfilter_conntrack/linux_nf_conntrack_common.h /usr/include/libnetfilter_conntrack/
exec_cmd cp -a src/.libs/libnetfilter_conntrack.so* /usr/lib/

cd ../bbfdm
exec_cmd cp -a libbbfdm-api/legacy/*.h /usr/include/libbbfdm-api/
exec_cmd cp -a libbbfdm-api/version-2/*.h /usr/include/libbbfdm-api/version-2/

ldconfig
