Command to extract sub images from FIT images.

The sub images of a FIT image can be extracted using the fdtextract
tool.
```
Usage: fdtextract [options] <file>

Options: -[le:o:s:a:hV]
  -l, --list            List images embedded in FIT
  -e, --extract <arg>   Extract image from FIT
  -o, --out <arg>       Output image name
  -s, --hash <arg>      Hash of image
  -a, --attribute <arg> Get attribute of FIT
  -z  --size <arg>      Size of embedded image in FIT
  -h, --help            Print this help and exit
  -V, --version         Print version and exit
```

List images contained in the FIT:
```
fdtextract -l /tmp/last.pkgtb
[0]: bootfs_6858_b0+
[1]: nand_squashfs
```

Extract images embedded int the FIT:
```
fdtextract -e bootfs_6858_b0+ /tmp/last.pkgtb -o /tmp/bootfs
Extracting: bootfs_6858_b0+ to /tmp/bootfs
```

Get the sha256 hash of the embedded image:
```
fdtextract -s bootfs_6858_b0+ /tmp/last.pkgtb
22858c4bfa6ab6227584bdc4d78cd6af195338617eeaf83804f8cfda66f8565
```

Get an attribute of the root node:
```
fdtextract -a description /tmp/last.pkgtb
Broadcom BCA image upgrade package tree binary
```
