#!/usr/bin/python3

import ubus
import pathlib

TEST_NAME = "validate ethernet manager stats"

print("Running: " + TEST_NAME)

rmon_stats = ["AllQueues", "BroadcastPackets", "Bytes", "CRCErroredPackets", "Enable", \
		 "Interface", "MulticastPackets", "Name", "OversizePackets", "Packets", \
		 "Packets1024to1518Bytes", "Packets128to255Bytes", "Packets256to511Bytes", \
		 "Packets512to1023Bytes", "Packets64Bytes", "Packets65to127Bytes"]

if_stats = ["BroadcastPacketsReceived", "BroadcastPacketsSent", "BytesReceived", "BytesSent", \
	       "DiscardPacketsReceived", "DiscardPacketsSent", "ErrorsReceived", "ErrorsSent", \
	       "MulticastPacketsReceived", "MulticastPacketsSent", "PacketsReceived", "PacketsSent", \
	       "UnicastPacketsReceived","UnicastPacketsSent", "UnknownProtoPacketsReceived"]

sock = pathlib.Path('/var/run/ubus/ubus.sock')
if sock.exists():
	assert ubus.connect('/var/run/ubus/ubus.sock')
else:
	assert ubus.connect()

out = ubus.call('bbfdm', 'add', {"path":"Device.Ethernet.RMONStats."})
inst = out[0]["results"][0]["data"]
assert int(inst) > 0, "Fail to add RMONStats instance"

out = ubus.call('bbfdm', 'set', {"path":"Device.Ethernet.RMONStats."+inst+".Enable","value":"1"})
assert int(out[0]["results"][0]["data"]) == 1, "Failed to enable RMONStats instance"

out = ubus.call('bbfdm', 'set', {"path":"Device.Ethernet.RMONStats."+inst+".Interface","value":"Device.Ethernet.Interface.5"})
assert int(out[0]["results"][0]["data"]) == 1, "Failed to set interface of RMONStats instance"

# test rmonstats
for i in rmon_stats:
	out = ubus.call('bbfdm', 'get', {"path":"Device.Ethernet.RMONStats."+inst+"."+i})
	print(out)
	assert str(out[0][i]) != "", "Fail at RMONSTAT " + i

# test ifstats
for i in if_stats:
	out = ubus.call('bbfdm', 'get', {"path":"Device.Ethernet.Interface.5.Stats."+i})
	print(out)
	assert str(out[0][i]) != "", "Fail at IFSTAT " + i

print("PASS: " + TEST_NAME)
