/*
 * helper.h - utility functions
 *
 * Copyright (C) 2024 iopsys Software Solutions AB. All rights reserved.
 *
 * Author: Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef HELPER_H
#define HELPER_H

#include <net/if.h>
#include <easy/easy.h>
#include <ethernet.h>
#include <libubus.h>
#include <libubox/blobmsg.h>
#include <libbbfdm-api/dmcommon.h>

void invoke_ethernet_hotplug(struct ubus_context *ctx, char *ifname, char *link);
int ethmngr_get_if_stats(char *ifname, struct eth_stats *s);
int ethmngr_get_rmon_stats(char *ifname, struct eth_rmon_stats *stats, int queueid, uint16_t vlan);
int ethmngr_clear_stats(char *ifname);

#endif
