/*
 * Copyright (C) 2019 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *      Author: Anis Ellouze <anis.ellouze@pivasoftware.com>
 *	Author: Amin Ben Ramdhane <amin.benramdhane@pivasoftware.com>
 *
 */

#ifndef __ETHERNET_H
#define __ETHERNET_H

#include "libbbfdm-api/dmcommon.h"

extern DM_MAP_OBJ tDynamicObj[];
extern DMOBJ tEthernetObj[];
extern DMLEAF tEthernetParams[];
extern DMOBJ tEthernetInterfaceObj[];
extern DMLEAF tEthernetInterfaceParams[];
extern DMLEAF tEthernetInterfaceStatsParams[];
extern DMOBJ tEthernetLinkObj[];
extern DMLEAF tEthernetLinkParams[];
extern DMLEAF tEthernetLinkStatsParams[];
extern DMOBJ tEthernetVLANTerminationObj[];
extern DMLEAF tEthernetVLANTerminationParams[];
extern DMLEAF tEthernetVLANTerminationStatsParams[];
extern DMLEAF tEthernetRMONStatsParams[];

#ifdef ETHMNGR_MACVLAN_EXTENSION
extern DMLEAF tEthernetMACVLANParams[];
extern DMOBJ tEthernetMACVLANObj[];
extern DMLEAF tEthernetMACVLANStatsParams[];

int addObjEthernetMACVLAN(char *refparam, struct dmctx *ctx, void *data, char **instance);
int delObjEthernetMACVLAN(char *refparam, struct dmctx *ctx, void *data, char *instance, unsigned char del_action);
int get_Ethernet_macVlanNumberOfEntries(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value);
#endif // ETHMNGR_MACVLAN_EXTENSION

#endif //__ETHERNET_H
