#!/bin/bash

function check_ret()
{
	ret=$1
	if [ "$ret" -ne 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function error_on_zero()
{
	ret=$1
	if [ "$ret" -eq 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1

	if [ $? -ne 0 ]; then
		echo "Failed to execute $@"
		exit 1
	fi
}

function generate_report()
{
	exec_cmd tap-junit --name "${1}" --input "${2}" --output report
	sync
}

function install_bbfdm()
{
	[ -d "/opt/dev/bbfdm" ] && rm -rf /opt/dev/bbfdm

	if [ -n "${BBFDM_BRANCH}" ]; then
		exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	else
		exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	fi

	cd /opt/dev/bbfdm
	rm -f test/files/usr/libexec/rpcd/ethernet
	rm -f /usr/libexec/rpcd/ethernet
	./gitlab-ci/install-dependencies.sh
	./gitlab-ci/setup.sh
}

function check_valgrind_xml() {
	echo "Memory check [$@] ..."
	valgrind-ci ${1} --summary
	exec_cmd valgrind-ci ${1} --abort-on-errors
}
