/*
 * helper.c - utility functions
 *
 * Copyright (C) 2024 iopsys Software Solutions AB. All rights reserved.
 *
 * Author: Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 *
 * See LICENSE file for license related information.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "helper.h"

int ethmngr_clear_stats(char *ifname)
{
	if (ifname == NULL)
		return -1;

	return eth_clear_stats(ifname);
}

int ethmngr_get_rmon_stats(char *ifname, struct eth_rmon_stats *rmon, int queueid, uint16_t vlan)
{
	if (ifname == NULL || rmon == NULL)
		return -1;

	if (strlen(ifname) == 0)
		return -1;

	memset(rmon, 0, sizeof(struct eth_rmon_stats));
	rmon->txq = queueid;
	rmon->vlanid = vlan;

	int ret = eth_get_rmon_stats(ifname, rmon);
	if (ret != 0) {
		BBF_DEBUG("ethmngr: failed to get rmonstats!");
		return -1;
	}

	return 0;
}

int ethmngr_get_if_stats(char *ifname, struct eth_stats *s)
{
	if (ifname == NULL || s == NULL)
		return -1;

	if (strlen(ifname) == 0)
		return -1;

	memset(s, 0, sizeof(struct eth_stats));
	int ret = eth_get_stats(ifname, s);
	if (ret != 0) {
		BBF_DEBUG("ethmngr: failed to get interface stats!");
		return -1;
	}

	return 0;
}
