#!/bin/bash

echo "Functional Test"
pwd

source ./gitlab-ci/shared.sh

make clean
make -C ./
ln -s ${PWD}/ethmngr /usr/sbin/ethmngr

supervisorctl update
sleep 5
supervisorctl status all
exec_cmd ubus wait_for bbfdm
exec_cmd ubus wait_for bbfdm.ethmngr

echo "## Running python based verification ##"
echo > ./funl-result.log
num=0
for test in `ls -1 ./test/*.py`
do
	num=$(( num + 1 ))
	$test
	if [ $? -eq 0 ]; then
		echo "ok ${num} - ${test}" >> ./funl-result.log
	else
		echo "not ok ${num} - ${test}" >> ./funl-result.log
	fi
done

echo "1..${num}" >> ./funl-result.log
generate_report python_test ./funl-result.log

supervisorctl stop all
supervisorctl status

# report part
# GitLab-CI output
gcovr -r .
# Artefact
gcovr -r . --xml -o ./functional-test-coverage.xml
date +%s > timestamp.log

cp /tmp/memory-report.xml ./
check_valgrind_xml "memory-report.xml" "ethmngr"

echo "Functional Test :: PASS"
