#!/bin/bash

echo "install dependencies"

# libeasy
cd /opt/dev
rm -fr libeasy
mkdir -p /usr/include/easy
git clone -b devel https://dev.iopsys.eu/hal/libeasy.git
cd libeasy
make
cp -a libeasy*.so* /usr/lib
cp -a *.h /usr/include/easy/

# libdsl
cd /opt/dev
rm -fr libdsl
git clone -b devel https://dev.iopsys.eu/hal/libdsl.git
cd libdsl
make PLATFORM=TEST
cp -a common.h xdsl.h xtm.h /usr/include
cp -a libdsl*.so* /usr/lib
sudo ldconfig

# json-editor
cd /opt/dev
git clone https://dev.iopsys.eu/iopsys/json-editor.git
cd json-editor
git checkout 44b32937a062ec4ffc9f7355841dc94ab6efa50f
cmake -DCMAKE_INSTALL_PREFIX=/usr -DCMAKE_BUILD_TYPE:String="Release" .
make
make install

# work around
pip uninstall -y jinja2
