# fast.line.&lt;number&gt;

| List of Methods                   |
| --- |
| [status](#status)                 |
| [stats](#stats)                   |
| [stats_interval](#stats_interval) |

## status

`status`

Type: `Method`

### Ubus CLI Example

```bash
ubus call fast.line.1 status
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "fast.line.1", "status"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
        "status": "up",
        "upstream": true,
        "firmware_version": "A2pvfbK047c1.d27l2",
        "link_status": "up",
        "current_profile": "106a",
        "power_management_state": "l0",
        "max_bit_rate": {
                "us": 166033,
                "ds": 712517
        },
        "allowed_profiles": [
                "106a",
                "106b",
                "106c",
                "212a",
                "212c"
        ],
        "success_failure_cause": 0,
        "upbokler": 210,
        "last_transmitted_signal": {
                "us": 0,
                "ds": 0
        },
        "upbokle": 0,
        "line_number": 1,
        "noise_margin": {
                "us": 80,
                "ds": 81
        },
        "attenuation": {
                "us": 0,
                "ds": 123
        },
        "power": {
                "us": 37,
                "ds": 0
        },
        "snrm_rmc": {
                "us": 326,
                "ds": 364
        },
        "bits_rmc_ps_ds": [

        ],
        "bits_rmc_ps_us": [

        ],
        "fext_to_cancel_enable": {
                "us": false,
                "ds": false
        },
        "etr": {
                "us": 0,
                "ds": 0
        },
        "att_etr": {
                "us": 0,
                "ds": 0
        },
        "min_eftr": {
                "us": 0,
                "ds": 0
        }
}
```

## stats

`stats`

Type: `Method`

### Ubus CLI Example

```bash
ubus call fast.line.1 stats
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "fast.line.1", "stats"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
        "bytes_sent": 0,
        "bytes_received": 0,
        "packets_sent": 0,
        "packets_received": 0,
        "errors_sent": 0,
        "errors_received": 0,
        "discard_packets_sent": 0,
        "discard_packets_received": 0,
        "total_start": 3705,
        "showtime_start": 1337,
        "last_showtime_start": 3680,
        "current_day_start": 3705,
        "quarter_hour_start": 105,
        "total": {
                "errored_secs": 33,
                "severely_errored_secs": 0,
                "loss": 0,
                "lors": 0,
                "uas": 23,
                "rtx_uc": 9203,
                "rtx_tx": 18241,
                "success_bsw": 207,
                "success_sra": 34,
                "success_fra": 32,
                "success_rpa": 0,
                "success_tiga": 0
        },
        "showtime": {
                "errored_secs": 0,
                "severely_errored_secs": 0,
                "loss": 0,
                "lors": 0,
                "uas": 0,
                "rtx_uc": 0,
                "rtx_tx": 711,
                "success_bsw": 76,
                "success_sra": 1,
                "success_fra": 0,
                "success_rpa": 0,
                "success_tiga": 0
        },
        "lastshowtime": {
                "errored_secs": 4294967295,
                "severely_errored_secs": 4294967295,
                "loss": 4294967295,
                "lors": 4294967295,
                "uas": 4294967295,
                "rtx_uc": 4294967295,
                "rtx_tx": 4294967295,
                "success_bsw": 4294967295,
                "success_sra": 4294967295,
                "success_fra": 4294967295,
                "success_rpa": 4294967295,
                "success_tiga": 4294967295
        },
        "currentday": {
                "errored_secs": 33,
                "severely_errored_secs": 0,
                "loss": 0,
                "lors": 0,
                "uas": 23,
                "rtx_uc": 9203,
                "rtx_tx": 18241,
                "success_bsw": 207,
                "success_sra": 34,
                "success_fra": 32,
                "success_rpa": 0,
                "success_tiga": 0
        },
        "quarterhour": {
                "errored_secs": 0,
                "severely_errored_secs": 0,
                "loss": 0,
                "lors": 0,
                "uas": 0,
                "rtx_uc": 0,
                "rtx_tx": 85,
                "success_bsw": 7,
                "success_sra": 0,
                "success_fra": 0,
                "success_rpa": 0,
                "success_tiga": 0
        }
}
```

## stats_interval

`stats <interval>`

Type: `Method`

### Ubus CLI Example

```bash
ubus call fast.line.1 stats "{ 'interval': 'total'}"
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "fast.line.1", "stats", "{ 'interval': 'total'}"]
}
```

### Input

- Type: `object`
- Parameter: `interval`
- Value: `total`, `showtime`, `lastshowtime`, `currentday`, or `quarterhour`

### Output

- type: `object`
- Example as below
```json
{
        "errored_secs": 20,
        "severely_errored_secs": 5,
        "loss": 1,
        "lors": 4294967295,
        "uas": 1,
        "rtx_uc": 4294967295,
        "rtx_tx": 0,
        "success_bsw": 1024,
        "success_sra": 2048,
        "success_fra": 1024,
        "success_rpa": 2048,
        "success_tiga": 1024
}
```
