# dsl

| List of Methods                   |
| --- |
| [status](#status)                 |
| [stats](#stats)                   |

## status

`status`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl status
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl", "status"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
  	"line": [
  		{
                        "id": 1,
                        "status": "up",
                        "upstream": true,
                        "firmware_version": "A2pvfbK047c1.d27l2",
                        "link_status": "up",
                        "xtse_used": [
                                "00",
                                "00",
                                "00",
                                "00",
                                "00",
                                "00",
                                "00",
                                "01"
                        ],
                        "standard_used": "vdsl2_annexa",
                        "current_profile": "17a",
                        "power_management_state": "l0",
                        "max_bit_rate": {
                                "us": 65421,
                                "ds": 151436
                        },
                        "line_encoding": "dmt",
                        "xtse": [
                                "0d",
                                "03",
                                "0c",
                                "00",
                                "c0",
                                "03",
                                "0c",
                                "01"
                        ],
                        "standards_supported": [
                                "t1413",
                                "gdmt_annexa",
                                "glite",
                                "adsl2_annexa",
                                "adsl2_annexm",
                                "adsl2p_annexa",
                                "adsl2p_annexm",
                                "vdsl2_annexa"
                        ],
                        "allowed_profiles": [
                                "8a",
                                "8b",
                                "8c",
                                "8d",
                                "12a",
                                "12b",
                                "17a",
                                "30a"
                        ],
                        "success_failure_cause": 0,
                        "upbokler_pb": [
                                162,
                                207,
                                224
                        ],
                        "rxthrsh_ds": [
                                0
                        ],
                        "act_ra_mode": {
                                "us": 1,
                                "ds": 1
                        },
                        "snr_mroc_us": 0,
                        "last_state_transmitted": {
                                "us": 0,
                                "ds": 0
                        },
                        "us0_mask": 8323072,
                        "trellis": {
                                "us": 1,
                                "ds": 1
                        },
                        "act_snr_mode": {
                                "us": 1,
                                "ds": 1
                        },
                        "line_number": 1,
                        "noise_margin": {
                                "us": 147,
                                "ds": 175
                        },
                        "snr_mpb_us": [
                                141,
                                175,
                                136,
                                0
                        ],
                        "snr_mpb_ds": [
                                174,
                                173,
                                176,
                                0
                        ],
                        "attenuation": {
                                "us": 0,
                                "ds": 51
                        },
                        "power": {
                                "us": 121,
                                "ds": 86
                        },
                        "xtur_vendor": "4244434D",
                        "xtur_country": "0000",
                        "xtur_ansi_std": 0,
                        "xtur_ansi_rev": 0,
                        "xtuc_vendor": "4244434D",
                        "xtuc_country": "0000",
                        "xtuc_ansi_std": 0,
                        "xtuc_ansi_rev": 42129,
                        "channel": [
                                {
                                        "id": 1,
                                        "status": "up",
                                        "link_encapsulation_used": "vdsl2_ptm",
                                        "curr_rate": {
                                                "us": 60085,
                                                "ds": 100120
                                        },
                                        "actndr": {
                                                "us": 59999,
                                                "ds": 99976
                                        },
                                        "link_encapsulation_supported": [
                                                "adsl2_atm",
                                                "adsl2_ptm",
                                                "vdsl2_atm",
                                                "vdsl2_ptm",
                                                "auto"
                                        ],
                                        "lpath": 0,
                                        "intlvdepth": 1,
                                        "intlvblock": 120,
                                        "actual_interleaving_delay": 0,
                                        "actinp": 0,
                                        "inpreport": false,
                                        "nfec": 240,
                                        "rfec": -1,
                                        "lsymb": 15080,
                                        "actinprein": {
                                                "us": 0,
                                                "ds": 0
                                        }
                                }
                        ]
  		}
  	]
}
```

## stats

`stats`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl stats
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl", "stats"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
  	"line": [
  		{
                        "id": 1,
                        "bytes_sent": 319970,
                        "bytes_received": 244818,
                        "packets_sent": 4661,
                        "packets_received": 3854,
                        "errors_sent": 0,
                        "errors_received": 0,
                        "discard_packets_sent": 0,
                        "discard_packets_received": 0,
                        "total_start": 1381821,
                        "showtime_start": 4643,
                        "last_showtime_start": 158812,
                        "current_day_start": 85821,
                        "quarter_hour_start": 321,
                        "total": {
                                "errored_secs": 69,
                                "severely_errored_secs": 0
                        },
                        "showtime": {
                                "errored_secs": 1,
                                "severely_errored_secs": 0
                        },
                        "lastshowtime": {
                                "errored_secs": 4294967295,
                                "severely_errored_secs": 4294967295
                        },
                        "currentday": {
                                "errored_secs": 6,
                                "severely_errored_secs": 0
                        },
                        "quarterhour": {
                                "errored_secs": 0,
                                "severely_errored_secs": 0
                        },
                        "channel": [
                                {
                                        "id": 1,
                                        "bytes_sent": 319970,
                                        "bytes_received": 244818,
                                        "packets_sent": 4661,
                                        "packets_received": 3854,
                                        "errors_sent": 0,
                                        "errors_received": 0,
                                        "discard_packets_sent": 0,
                                        "discard_packets_received": 0,
                                        "total_start": 0,
                                        "showtime_start": 0,
                                        "last_showtime_start": 0,
                                        "current_day_start": 85821,
                                        "quarter_hour_start": 321,
                                        "total": {
                                                "xtur_fec_errors": 0,
                                                "xtuc_fec_errors": 0,
                                                "xtur_hec_errors": 4294967295,
                                                "xtuc_hec_errors": 4294967295,
                                                "xtur_crc_errors": 215,
                                                "xtuc_crc_errors": 83
                                        },
                                        "showtime": {
                                                "xtur_fec_errors": 0,
                                                "xtuc_fec_errors": 0,
                                                "xtur_hec_errors": 0,
                                                "xtuc_hec_errors": 0,
                                                "xtur_crc_errors": 6,
                                                "xtuc_crc_errors": 1
                                        },
                                        "lastshowtime": {
                                                "xtur_fec_errors": 4294967295,
                                                "xtuc_fec_errors": 4294967295,
                                                "xtur_hec_errors": 4294967295,
                                                "xtuc_hec_errors": 4294967295,
                                                "xtur_crc_errors": 4294967295,
                                                "xtuc_crc_errors": 4294967295
                                        },
                                        "currentday": {
                                                "xtur_fec_errors": 0,
                                                "xtuc_fec_errors": 0,
                                                "xtur_hec_errors": 4294967295,
                                                "xtuc_hec_errors": 4294967295,
                                                "xtur_crc_errors": 18,
                                                "xtuc_crc_errors": 7
                                        },
                                        "quarterhour": {
                                                "xtur_fec_errors": 0,
                                                "xtuc_fec_errors": 0,
                                                "xtur_hec_errors": 4294967295,
                                                "xtuc_hec_errors": 4294967295,
                                                "xtur_crc_errors": 0,
                                                "xtuc_crc_errors": 0
                                        }
                                }
                        ]
  		}
  	]
}
```
