# dsl.channel.&lt;number&gt;

| List of Methods                   |
| --- |
| [status](#status)                 |
| [stats](#stats)                   |
| [stats_interval](#stats_interval) |

## status

`status`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl.channel.1 status
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl.channel.1", "status"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
        "status": "up",
        "link_encapsulation_used": "vdsl2_ptm",
        "curr_rate": {
                "us": 60085,
                "ds": 100120
        },
        "actndr": {
                "us": 59999,
                "ds": 99976
        },
        "link_encapsulation_supported": [
                "adsl2_atm",
                "adsl2_ptm",
                "vdsl2_atm",
                "vdsl2_ptm",
                "auto"
        ],
        "lpath": 0,
        "intlvdepth": 1,
        "intlvblock": 120,
        "actual_interleaving_delay": 0,
        "actinp": 0,
        "inpreport": false,
        "nfec": 240,
        "rfec": -1,
        "lsymb": 15080,
        "actinprein": {
                "us": 0,
                "ds": 0
        }
}
```

## stats

`stats`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl.channel.1 stats
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl.channel.1", "stats"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
        "bytes_sent": 373384,
        "bytes_received": 285514,
        "packets_sent": 5443,
        "packets_received": 4499,
        "errors_sent": 0,
        "errors_received": 0,
        "discard_packets_sent": 0,
        "discard_packets_received": 0,
        "total_start": 0,
        "showtime_start": 0,
        "last_showtime_start": 0,
        "current_day_start": 206,
        "quarter_hour_start": 206,
        "total": {
                "xtur_fec_errors": 0,
                "xtuc_fec_errors": 0,
                "xtur_hec_errors": 4294967295,
                "xtuc_hec_errors": 4294967295,
                "xtur_crc_errors": 215,
                "xtuc_crc_errors": 83
        },
        "showtime": {
                "xtur_fec_errors": 0,
                "xtuc_fec_errors": 0,
                "xtur_hec_errors": 0,
                "xtuc_hec_errors": 0,
                "xtur_crc_errors": 6,
                "xtuc_crc_errors": 1
        },
        "lastshowtime": {
                "xtur_fec_errors": 4294967295,
                "xtuc_fec_errors": 4294967295,
                "xtur_hec_errors": 4294967295,
                "xtuc_hec_errors": 4294967295,
                "xtur_crc_errors": 4294967295,
                "xtuc_crc_errors": 4294967295
        },
        "currentday": {
                "xtur_fec_errors": 0,
                "xtuc_fec_errors": 0,
                "xtur_hec_errors": 4294967295,
                "xtuc_hec_errors": 4294967295,
                "xtur_crc_errors": 0,
                "xtuc_crc_errors": 0
        },
        "quarterhour": {
                "xtur_fec_errors": 0,
                "xtuc_fec_errors": 0,
                "xtur_hec_errors": 4294967295,
                "xtuc_hec_errors": 4294967295,
                "xtur_crc_errors": 0,
                "xtuc_crc_errors": 0
        }
}
```

## stats_interval

`stats <interval>`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl.channel.1 stats "{ 'interval': 'total'}"
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl.channel.1", "stats", "{ 'interval': 'total'}"]
}
```

### Input

- Type: `object`
- Parameter: `interval`
- Value: `total`, `showtime`, `lastshowtime`, `currentday`, or `quarterhour`

### Output

- type: `object`
- Example as below
```json
{
        "xtur_fec_errors": 0,
        "xtuc_fec_errors": 0,
        "xtur_hec_errors": 4294967295,
        "xtuc_hec_errors": 4294967295,
        "xtur_crc_errors": 215,
        "xtuc_crc_errors": 83
}
```
