# atm.link.&lt;number&gt;

| List of Methods                   |
| --- |
| [status](#status)                 |
| [stats](#stats)                   |
| [configure](#configure)           |

## status

`status`

Type: `Method`

### Ubus CLI Example

```bash
ubus call atm.link.1 status
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "atm.link.1", "status"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
        "status": "up",
        "link_type": "eoa",
        "auto_config": true,
        "dest_addr": {
                "vpi": 8,
                "vci": 35
        },
        "encapsulation": "llc",
        "fcs_preserved": true,
        "vc_search_list": [
                {
                        "vpi": 8,
                        "vci": 36
                },
                {
                        "vpi": 8,
                        "vci": 37
                }
        ],
        "aal": "aal5",
        "qos": {
                "qos_class": "ubr",
                "peak_cell_rate": 18867,
                "max_burst_size": 22640,
                "sustainable_cell_rate": 15093
        }
}
```

## stats

`stats`

Type: `Method`

### Ubus CLI Example

```bash
ubus call atm.link.1 stats
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "atm.link.1", "stats"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
        "transmitted_blocks": 12345678,
        "received_blocks": 87654321,
        "crc_errors": 12
}
```

## configure

`configure {...}`

Type: `Method`

### Ubus CLI Example

```bash
ubus call atm.link.1 configure "{'link_type':'eoa','vpi':8,'vci':35,'encapsulation':'llc',\
    'qos_class':'ubr','peak_cell_rate':10240,'max_burst_size':8124,'sustainable_cell_rate':9600}"
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "atm.link.1", "configure", "{'link_type':'eoa','vpi':8,'vci':35,'encapsulation':'llc'}"]
}
```

### Input

- Type: `object`
- Parameter: `link_type`
- Value: ATM link type with one of values "eoa", "ipoa", "pppoa" and "cip"
- Parameer:`vpi`
- Value: unsigned int as virtual path index
- Parameer:`vci`
- Value: unsigned int as virtual circuit index
- Parameer:`encapsulation`
- Value: ATM link encapsulation with one of values "llc" and "vcmux"
- Parameer:`qos_class`
- Value: ATM QoS class with one of values "ubr", "cbr", "gfr", "vbr_nrt", "vbr_rt", "ubr_plus" and "abr"
- Parameer:`peak_cell_rate`
- Value: unsigned integer
- Parameer:`max_burst_size`
- Value: unsigned integer
- Parameer:`sustainable_cell_rate`
- Value: unsigned integer

### Output

None

