/*
 * Copyright (C) 2024 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *		Author: Amit Kumar <amit.kumar@iopsys.eu>
 *
 */

#include "libbbfdm-api/dmcommon.h"
#include "plugin.h"

int get_line_linkstatus(json_object *obj, char **value)
{
	char *link_status = dmjson_get_value(obj, 1, "link_status");

	if (DM_LSTRCMP(link_status, "up") == 0)
		*value = "Up";
	else if (DM_LSTRCMP(link_status, "initializing") == 0)
		*value = "Initializing";
	else if (DM_LSTRCMP(link_status, "no_signal") == 0)
		*value = "NoSignal";
	else if (DM_LSTRCMP(link_status, "disabled") == 0)
		*value = "Disabled";
	else if (DM_LSTRCMP(link_status, "establishing") == 0)
		*value = "EstablishingLink";
	else if (DM_LSTRCMP(link_status, "error") == 0)
		*value = "Error";
	else
		*value = link_status;
	return 0;
}
void remove_device_from_interface(struct uci_section *interface_s, char *device)
{
	char *curr_device  = NULL;
	char new_device[64] = {0};
	size_t pos = 0;

	if (!interface_s || !device)
		return;

	dmuci_get_value_by_section_string(interface_s, "device", &curr_device);
	if (DM_STRLEN(curr_device) == 0)
		return;

	new_device[0] = '\0';

	char *pch = NULL, *spch = NULL;
	for (pch = strtok_r(curr_device, " ", &spch); pch; pch = strtok_r(NULL, " ", &spch)) {

		if (strcmp(pch, device) == 0)
			continue;

		pos += (size_t)snprintf(&new_device[pos], sizeof(new_device) - pos, "%s ", pch);
	}

	if (pos)
		new_device[pos - 1] = 0;

	dmuci_set_value_by_section(interface_s, "device", new_device);
}

DM_MAP_OBJ tDynamicObj[] = {
/* parentobj, nextobject, parameter */
{"Device.", tDeviceDSLObj, NULL},
{"Device.", tDeviceFASTObj, NULL},
{"Device.", tDeviceATMObj, NULL},
{"Device.", tDevicePTMObj, NULL},
{0}
};
