/*
 * utils.h - Utility function headers
 *
 * Copyright (C) 2020 iopsys Software Solutions AB. All rights reserved.
 *
 * Author: yalu.zhang@iopsys.eu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */
#include <libubus.h>
#include <libubox/blobmsg.h>

extern struct json_object *json_output;
extern const char *interval_types[];

void validate_dsl_line_status(struct json_object *json_obj);
void validate_dsl_channel_status(struct json_object *json_obj);
void validate_dsl_status(struct json_object *json_obj);
void validate_dsl_line_stats(struct json_object *json_obj);
void validate_dsl_line_stats_interval(struct json_object *json_obj, const char *interval);
void validate_dsl_channel_stats(struct json_object *json_obj);
void validate_dsl_channel_stats_interval(struct json_object *json_obj, const char *interval);
void validate_dsl_stats(struct json_object *json_obj);
