#!/bin/bash
set -e

echo "preparation script"

pwd

supervisorctl status all
supervisorctl update
sleep 3
supervisorctl status all

make functional-test -C .

# run API validation
supervisorctl stop all
supervisorctl status > /dev/null && echo $?
# cleanup
supervisorctl remove ubusd

# report part
# GitLab-CI output
gcovr -r .
# Artefact
gcovr -r . --html -o ./functional-test-coverage.html
