#!/bin/bash
set -e
echo "preparation script"

pwd

make coverage -C ./
ln -s $PWD/dslmngr /usr/sbin/dslmngr
supervisorctl status all
supervisorctl update
sleep 3
supervisorctl status all

# run API validation
ubus-api-validator -d ./test/api/json/ > ./api-result.log
supervisorctl stop all
supervisorctl status > /dev/null && echo $?

# cleanup
supervisorctl remove dslmngr
supervisorctl remove ubusd

# report part
gcovr -r . --html --html-details -o ./api-test-coverage.html
gcovr -r .
cp /tmp/memory-report.xml /builds/hal/dslmngr/api-test-memory-report.xml
tap-junit --input ./api-result.log --output report

