# dsl.line.&lt;number&gt;

| List of Methods                   |
| --- |
| [status](#status)                 |
| [stats](#stats)                   |
| [stats_interval](#stats_interval) |
| [configure](#configure)           |

## status

`status`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl.line.1 status
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl.line.1", "status"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
        "status": "up",
        "upstream": true,
        "firmware_version": "A2pvfbK047c1.d27l2",
        "link_status": "up",
        "xtse_used": [
                "00",
                "00",
                "00",
                "00",
                "00",
                "00",
                "00",
                "01"
        ],
        "standard_used": "vdsl2_annexa",
        "current_profile": "17a",
        "power_management_state": "l0",
        "max_bit_rate": {
                "us": 65421,
                "ds": 151416
        },
        "line_encoding": "dmt",
        "xtse": [
                "0d",
                "03",
                "0c",
                "00",
                "c0",
                "03",
                "0c",
                "01"
        ],
        "standards_supported": [
                "t1413",
                "gdmt_annexa",
                "glite",
                "adsl2_annexa",
                "adsl2_annexm",
                "adsl2p_annexa",
                "adsl2p_annexm",
                "vdsl2_annexa"
        ],
        "allowed_profiles": [
                "8a",
                "8b",
                "8c",
                "8d",
                "12a",
                "12b",
                "17a",
                "30a"
        ],
        "success_failure_cause": 0,
        "upbokler_pb": [
                162,
                207,
                224
        ],
        "rxthrsh_ds": [
                0
        ],
        "act_ra_mode": {
                "us": 1,
                "ds": 1
        },
        "snr_mroc_us": 0,
        "last_state_transmitted": {
                "us": 0,
                "ds": 0
        },
        "us0_mask": 8323072,
        "trellis": {
                "us": 1,
                "ds": 1
        },
        "act_snr_mode": {
                "us": 1,
                "ds": 1
        },
        "line_number": 1,
        "noise_margin": {
                "us": 147,
                "ds": 175
        },
        "snr_mpb_us": [
                137,
                175,
                136,
                0
        ],
        "snr_mpb_ds": [
                174,
                173,
                176,
                0
        ],
        "attenuation": {
                "us": 0,
                "ds": 51
        },
        "power": {
                "us": 121,
                "ds": 86
        },
        "xtur_vendor": "4244434D",
        "xtur_country": "0000",
        "xtur_ansi_std": 0,
        "xtur_ansi_rev": 0,
        "xtuc_vendor": "4244434D",
        "xtuc_country": "0000",
        "xtuc_ansi_std": 0,
        "xtuc_ansi_rev": 42129
}
```

## stats

`stats`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl.line.1 stats
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl.line.1", "stats"]
}
```

### Input

None

### Output

- type: `object`
- Example as below
```json
{
        "bytes_sent": 360788,
        "bytes_received": 276184,
        "packets_sent": 5259,
        "packets_received": 4350,
        "errors_sent": 0,
        "errors_received": 0,
        "discard_packets_sent": 0,
        "discard_packets_received": 0,
        "total_start": 1382424,
        "showtime_start": 5247,
        "last_showtime_start": 159416,
        "current_day_start": 24,
        "quarter_hour_start": 24,
        "total": {
                "errored_secs": 69,
                "severely_errored_secs": 0
        },
        "showtime": {
                "errored_secs": 1,
                "severely_errored_secs": 0
        },
        "lastshowtime": {
                "errored_secs": 4294967295,
                "severely_errored_secs": 4294967295
        },
        "currentday": {
                "errored_secs": 0,
                "severely_errored_secs": 0
        },
        "quarterhour": {
                "errored_secs": 0,
                "severely_errored_secs": 0
        }
}
```

## stats_interval

`stats <interval>`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl.line.1 stats "{ 'interval': 'total'}"
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl.line.1", "stats", "{ 'interval': 'total'}"]
}
```

### Input

- Type: `object`
- Parameter: `interval`
- Value: `total`, `showtime`, `lastshowtime`, `currentday`, or `quarterhour`

### Output

- type: `object`
- Example as below
```json
{
        "errored_secs": 69,
        "severely_errored_secs": 0
}
```

## configure

`configure {...}`

Type: `Method`

### Ubus CLI Example

```bash
ubus call dsl.line.1 configure "{'xtse':'01,02,ab,cd,41,52,f8,6e',\
    'vdsl2_profiles':'8a,8b,8c,8d,17a,30a,35b',\
    'fast_profiles':'106a,212a','data_gathering':true,'limit_mask':255,'us0_mask':511}"
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "dsl.line.1", "configure", "{'xtse':'01,02,ab,cd,41,52,f8,6e','vdsl2_profiles':'8a,8b,8c,8d,17a,30a,35b'}"]
}
```

### Input

- Type: `object`
- Parameter: `xtse`
- Value: 8 octects which include all modes supported by the DSL line
- Parameer:`vdsl2_profiles`
- Value: Sub/full set of "8a,8b,8c,8d,17a,30a,35b" of VDSL2 profiles
- Parameer:`fast_profiles`
- Value: Sub/full set of "106a,212a" of FAST profiles
- Parameer:`data_gathering`
- Value: true or false to enale/disable data gathering
- Parameer:`limit_mask`
- Value: unsigned integer as limit mask
- Parameer:`us0_mask`
- Value: unsigned integer as us0 mask


### Output

None

