# DSL Manager

*dslmngr* implements the DSL data model, publishing the dsl objects over ubus.
In order to remain agnostic to the vendor and underlying DSL modules present
in the system, *dslmngr* uses the easy-soc-libs libdsl APIs to expose supported
methods within its objects.

## Overview

*dslmngr* provides the following functionalities:
1. DSL line status
2. DSL channel status
3. DSL line statistics
4. DSL channel statistics

### UCI Config

UCI configuration parameters are parsed and taken effect by startup scripts at present. In the future will this be
handled by *dslmngr*.

```bash
config dsl-line 'line'
	option bitswap '1'
	option sra '1'
	option us0 '1'
	list mode 'gdmt'
	list mode 'glite'
	list mode 't1413'
	list mode 'adsl2'
	list mode 'adsl2p'
	list mode 'annexl'
	list mode 'annexm'
	list mode 'vdsl2'
	list profile '8a'
	list profile '8b'
	list profile '8c'
	list profile '8d'
	list profile '12a'
	list profile '12b'
	list profile '17a'
	list profile '30a'
	list profile '35b'
	list profile '35b'
	list profile '35b'
	list profile '35b'

config atm-device 'atm0'
	option name 'ATM'
	option vpi '8'
	option vci '35'
	option device 'atm0'
	option link_type 'eoa'
	option encapsulation 'llc'
	option qos_class 'ubr'

config ptm-device 'ptm0'
	option name 'PTM'
	option device 'ptm0'
	option priority '1'
	option portid '1'
```

### Ubus API

This is a verbose print of all methods published to ubus on a device.

```bash
'atm.link.0' @607d41d6
        "status":{}
        "stats":{}
        "configure":{"link_type":"String","vpi":"Integer","vci":"Integer","encapsulation":"String","qos_class":"String","peak_cell_rate":"Integer","max_burst_size":"Integer","sustainable_cell_rate":"Integer"}
'dsl' @8e73ca86
        "status":{}
        "stats":{}
'dsl.channel.0' @e76e0883
        "status":{}
        "stats":{"interval":"String"}
'dsl.line.0' @3a06e2d2
        "status":{}
        "stats":{"interval":"String"}
        "configure":{"xtse":"String","vdsl2_profiles":"String","fast_profiles":"String","data_gathering":"Boolean","limit_mask":"Integer","us0_mask":"Integer"}
'fast.line.0' @bc51c0a7
        "status":{}
        "stats":{"interval":"String"}
'ptm.link.0' @35822197
        "status":{}
```

For more info on the Ubus API see [link](./docs/ubus.splash.md)

## Tests

This section gives a brief overview of the tests for *dslmngr*, for a detailed report see
[test specification](./docs/testspec.md)

To test *dslmngr*, the scope of the tests has to be clearly defined, as *dslmngr*
is heavily dependent on libdsl:

1. Verify linkage between *dslmngr* and libdsl APIs
2. Verify that the dsl structures are correctly prepared and returned data is
used correctly by *dslmngr*
3. Verify that API calls successfully reach libdsl and if passed input is of
correct format

As the test environment runs in a Ubuntu Docker environment, with little
possibility to prepare DSL drivers and kernel version, the easy-soc-libs has to
be extended to support APIs to run on a test platform, returning dummy data for
getters.

To ensure full coverage, the getters are tested by both unit-test and functional-api test.

## Dependencies

To successfully build *dslmngr*, the following libraries are needed:

| Dependency            | Link                                                                                  | License        |
| ----------------- | ----------------------------------------------------------------  | -------------- |
| libuci                | https://git.openwrt.org/project/uci.git                                               | LGPL 2.1       |
| libubox               | https://git.openwrt.org/project/libubox.git                                           | BSD            |
| libubus               | https://git.openwrt.org/project/ubus.git                                              | LGPL 2.1       |
| libjson-c             | https://s3.amazonaws.com/json-c_releases                                              | MIT            |
| libdsl                       | https://dev.iopsys.eu/iopsys/easy-soc-libs/tree/devel/libdsl         | GNU GPL2       |
| libnl3                        |                                                                                                                                       |                            |
| libblobmsg_json       |                                                                                                                                       |                            |
| libnl-genl            |                                                                                       |                |

Additionally, in order to build with the tests, the following libraries are needed:

| Dependency                            | Link                                                                  | License               |
| ------------------------- | --------------------------------------------------------- | ------------- |
| libjson-validator             | https://github.com/pboettch/json-schema-validator             | LGPL 2.1              |
| libjson-schema-validator      | https://dev.iopsys.eu/iopsys/json-schema-validator            |                               |
| libjson-editor                        | https://dev.iopsys.eu/iopsys/json-editor                              |                               |
