/*
 * Copyright (C) 2024 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *	Author: Mohd Husaam Mehdi <husaam.mehdi@iopsys.eu>
 *
 */

#ifndef __DNS_SD_H
#define __DNS_SD_H

#include <libbbfdm_api.h>
#include "libbbfdm-api/dmcommon.h"

#define HOSTS_LIST_SIZE                 1024
#define HOST_STR_SIZE                   32

// for cppcheck warnings
#define JSON_NULL_AND_RETURN_MSG(X, CTX, MSG, RV) \
	if (X == NULL) { \
		bbfdm_set_fault_message(CTX, MSG); \
		return RV; \
	}

struct srv_info
{
	char *instance_name;
	char *application_protocol;
	bool transport_protocol_flag;
};

enum enum_transport_protocol
{
	TRANSPORT_TCP,
	TRANSPORT_UDP
};

extern DMOBJ tDNSPluginObj[];
extern DMOBJ tDNSSDObj[];
extern DMLEAF tDNSSDParams[];
extern DMLEAF tDNSSDServiceParams[];
extern DMOBJ tDNSSDServiceObj[];
extern DMLEAF tDNSSDServiceTextRecordParams[];
extern DMLEAF tDNSSDAdvertiseParams[];
extern DMOBJ tDNSSDAdvertiseObj[];
extern DMLEAF tDNSSDAdvertiseTextRecordParams[];

#endif
